.\" documentation file generated from SDFRaisedCos.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "RaisedCos"
.SD
An FIR filter with a magnitude frequency response shaped
like the standard raised cosine used in digital communications.
By default, the star upsamples by a factor of 16, so 16 outputs
will be produced for each input unless the "interpolation"
parameter is changed.
.SE
.LO "SDF dsp library"
.DM SDF SDFFIR
.SV 2.9 "11/25/92"
.AL "J. T. Buck"
.SH
.NE
\fIN\fR (IntState): Number of taps
.DF "64"
.NE
\fIP\fR (IntState): Distance from center to first zero crossing
.DF "16"
.NE
\fIexcessBW\fR (FloatState): Excess bandwidth, between 0 and 1
.DF "1.0"
.ET
.LD
This star implements an FIR filter with
a raised cosine frequency response, with the excess bandwidth given
by \fIexcessbw\fR and the distance from center to first
zero crossing given by \fIP\fP.
The length of the filter (the number of taps) is \fIN\fP.
Ideally, the impulse response of the filter would be
.EQ
h(n) ~=~ left ( { sin ( pi n / P ) } over { pi n / P } right )
left ( { cos ( alpha pi n / P ) } over { 1 minus 2 alpha n / P } right )
.EN
where $alpha$ is \fIexcessbw\fR.
However, this pulse is centered at zero, and we can only implement causal
filters in the SDF domain in Ptolemy.  Hence, the inpulse response is
actually
.EQ
g(n) ~=~ h(n - M)
.EN
where $M ~=~ N/2$ if $N$ is even, and $M ~=~ (N+1)/2$ if $N$ is odd.
Since the impulse response is simply truncated outside this range,
note that if $N$ is even the impulse response will not be symmetric.
It will have one more sample to the left than to the right of center.
Unless this extra sample is zero, the filter will not have linear phase
if $N$ is even.
.sp
The output sample rate is \fIupsample\fP times the input.
This is set by default to 16 becuase in digital communication systems
this pulse is used for line coding of symbols, and upsampling is necessary.
The star is implemented by deriving from the FIR star.
.Id "raised cosine pulse"
.Id "Nyquist pulse"
.UH REFERENCES
.ip [1]
E. A. Lee and D. G. Messerchmitt,
"Digital Communication," Kluwer Academic Publishers, 1988.
.SA
FIR.
.ES
