.\" @(#)SDFPCMBitCoder.t	1.1	12/17/92
.NA PCMBitCoder
.SD
Converts voice samples to 64 kbps bit stream
using CCITT Recommendation G.711.
.DE
.CO "1992 The Regents of The Univeristy of California"
.LO "SDF conversion palette (galaxy)"
.DM SDF SDFGalaxy
.SV 1.1 12/17/92
.AL "G.S. Walter"
.Sr Sgn SDF
.Sr Quantizer SDF
.Sf IntToBits
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fIoutput\fR (int)
.PE
.LD
This galaxy is designed to encode a sample of speech
using CCITT Recommendation G.711.  The input is a sample
of 8 kHz voice and the output consists of the quantized
samples's eight-bit codeword.
.pp
It is interesting to note
with this design the functionality of the coder around 0.
Any input value between [-0.5, 0.5] should be given the
encoded value of 0.  But 0 may be represented in bits as
either 10000000 (decimal 128) or 00000000 (decimal 0).
Due to the nature of the 
.c Sgn
star the levels chosen for the 
.c Quantizer
star, the values in [-0.5, 0) will be encoded as
00000000 and those between [0, 0.5] will be transformed
to 10000000.  The decoder,
.c PCMBitDecoder,
is able to recognize both implementations as the
decoded magnitude 0. 
.pp
Otherwise, the encoding is straight forward.  The magnitude
of an input sample is put through a quantizer which will
return the decimal equivalent of the proper 8-bit
codeword.  The upper quantizer is used to modify the sign
bit of the codeword.  The
.c IntToBits
star will then output the proper eight bits.
.SA
.c PCMBitDecoder
.ES

