.\" documentation file generated from SDFLevDur.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LevDur"
.SD
Levinson-Durbin algorithm.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.13 "12/8/92"
.AL "E. A. Lee"
.IH
.NE
\fIautocor\fR (float): Autocorrelation estimate
.PE
.OH
.NE
\fIlp\fR (float): FIR linear predictor coefficients output.
.NE
\fIrefl\fR (float): Lattice predictor coefficients output.
.NE
\fIerrPower\fR (float): Prediction error power.
.PE
.SH
.NE
\fIorder\fR (IntState): The order of the recursion.
.DF "8"
.ET
.LD
.pp
This star takes inputs from the
.c Autocor
star and uses the Levinson-Durbin
algorithm to compute both reflection coefficients and FIR linear
predictor coefficients.
.Ir "spectral estimation, maximum entropy"
.Ir "maximum entropy spectral estimation"
.Sr "Autocor"
If the
.c Autocor
star is set so that it's \fIunbiased\fR parameter is zero,
then the combined effect of that star and this one is called the
autocorrelation algorithm.
.Ir "autocorrelation method"
The given order should be the same as the \fInoLags\fR parameter of the
.c Autocor
star.  Three outputs are generated.
On the \fIerrPower\fR output, a sequence of $order ~+~ 1$
samples gives the prediction
error power for each predictor order from zero to \fIorder\fR.
The first sample, the corresponding to the zeroth order predictor,
is simply an estimate of the power of the input process.
Note that for signals without noise, the \fIerrPower\fR output can sometimes
end up being a small negative number.
.pp
The \fIlp\fR output gives the coefficients of an FIR filter that
performs linear prediction for the input process.
.Ir "linear prediction"
This set of coefficients is suitable for directly feeding a
.c BlockFIR
filter star that accepts outside coefficients.
.Sr "BlockFIR"
The number of coefficients produced is equal to the \fIorder\fR.
The final output \fIrefl\fR is the reflection coefficients,
suitable for feeding directly to a
.c BlockLattice
star, which will then generate the forward and backward prediction error.
.Sr "BlockLattice"
The number of coefficients produced is equal to the \fIorder\fR.
.pp
Note that the definition of reflection coefficients is not quite
universal in the literature.
.Ir "reflection coefficients"
.Ir "coefficients, reflection"
The reflection coefficients in references [2] and [3]
are the negative of the ones generated by this star, which
correspond to the definition in most other texts,
and to the definition of partial-correlation (PARCOR)
coefficients in the statistics literature.
.Ir "partial correlation coefficients"
.Ir "coefficients, partial correlation"
.Ir "PARCOR"
.UH REFERENCES
.ip [1]
J. Makhoul, "Linear Prediction: A Tutorial Review",
\fIProc. IEEE\fR, Vol. 63, pp. 561-580, Apr. 1975.
.ip [2]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.ip [3]
S. Haykin, \fIModern Filters\fR, MacMillan Publishing Company,
New York, 1989.
.SA
Autocor,
BlockFIR and
linearPrediction.
.ES
