.\" documentation file generated from SDFLMSPlotCx.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LMSPlotCx"
.SD
Complex adaptive filter using LMS adaptation algorithm.  In addition,
the tap coefficients are plotted using the xgraph program, with a
separate plot for the magnitude and phase.  If "trace" is NO, only the
final tap values are plotted; if it is YES, a trace of each tap is
plotted as it adapts.
.SE
.LO "SDF dsp library"
.DM SDF SDFLMSCx
.SV 1.10 "11/25/92"
.AL "J. T. Buck"
.SH
.NE
\fIgraphOptsMag\fR (StringState): options for magnitude graph
.DF ""
.NE
\fIgraphOptsPhase\fR (StringState): options for phase graph
.DF ""
.NE
\fIgraphTitleMag\fR (StringState): title for magnitude graph
.DF "LMS filter tap magnitudes"
.NE
\fIgraphTitlePhase\fR (StringState): title for phase graph
.DF "LMS filter tap phases"
.NE
\fItrace\fR (IntState): if YES, plot a trace of tap values as they adapt
.DF "NO"
.ET
.LD
This star is exactly like the LMSCx star, except that, in addition,
it makes a plot of the tap coefficients, one plot for the magnitude,
one for the phase.  It can produce two types of plots: a plot
of the final tap values or a plot that traces the
time evolution of each tap value: the time evolution is obtained
if \fItrace\fP is YES.
.Id "adaptive filter, complex"
.Id "filter, adaptive, complex"
.Id "LMS adaptive filter, complex"
.Id "filter, LMS adaptive, complex"
.lp
\fIGraphTitleMag\fP is used for the title of the magnitude plot;
\fIGraphTitlePhase\fP is used for the title of the phase plot;
\fIGraphOptsMag\fP is handed to the xgraph program as option
values on the command line when the magnitudes are plotted, and
\fIGraphOptsPhase\fP serves the same function for the phase.
.lp
If \fItrace\fP is YES, there may not be more than 64 taps in the filter.
.SA
LMSCx,
Xgraph and
XMgraph.
.ES
