.\" documentation file generated from SDFLMSPlot.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LMSPlot"
.SD
Adaptive filter using LMS adaptation algorithm.  In addition,
the tap coefficients are plotted using the xgraph program, with a
separate plot for the magnitude and phase.  If "trace" is NO, only the
final tap values are plotted; if it is YES, a trace of each tap is
plotted as it adapts.
.SE
.LO "SDF dsp library"
.DM SDF SDFLMS
.SV 1.5 "11/25/92"
.AL "J. T. Buck"
.SH
.NE
\fIgraphOptions\fR (StringState): options for graph
.DF "-0 taps"
.NE
\fIgraphTitle\fR (StringState): title for graph
.DF "LMS filter tap values"
.NE
\fItrace\fR (IntState): if YES, plot a trace of tap values as they adapt
.DF "NO"
.ET
.LD
This star is exactly like the LMS star, except that, in addition,
it makes a plot of the tap coefficients.
.Id "adaptive filter with coefficient plotting"
.Id "filter, adaptive, with coefficient plotting"
.Id "filter, LMS, with coefficient plotting"
.Id "LMS adaptive filter with coefficient plotting"
It can produce two types
of plots: a plot of the final tap values or a plot that traces the
time evolution of each tap value: the time evolution is obtained
if \fItrace\fP is YES.
.lp
\fIgraphTitle\fP is used for the title of the plot; \fIgraphOptions\fP
is handed to the xgraph program as option values on the command line.
.lp
If \fItrace\fP is YES, there may not be more than 64 taps in the filter.
.SA
LMS,
Xgraph and
XMgraph.
.ES
