.\" documentation file generated from SDFLMSLeak.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LMSLeak"
.SD
An LMS-based adaptive filter in which the step size is input (to the
"step" input) every iteration. The "stepSize" state is unused.

Values in the "taps" array change as the filter adapts to minimize the
energy at the "error" input.

The "mu" state is used as a leak factor in the formula that updates
the filter coefficients.
.SE
.LO "SDF dsp library"
.DM SDF SDFLMS
.SV 1.4 "11/25/92"
.AL "E. A. Lee, Paul Haskell"
.IH
.NE
\fIstep\fR (float): Step-size for LMS algorithm.
.PE
.SH
.NE
\fImu\fR (FloatState): Leak factor for coefficient update.
.DF "0.0"
.ET
.LD
If two identical "LMSLeak" filters are used as an adaptive predictive
coder and decoder, then with "mu" nearly equal to but greater than 0.0,
the effects of channel errors between the coder and decoder will decay
away rather than accumulate. As "mu" increases, the effects of channel
errors decay away more quickly, but the size of the "error" input
increases also.

See pg 54 of _Adaptive_Filters_, Honig and Messerschmitt.
.SA
LMS.
.ES
