.\" documentation file generated from SDFIIR.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "IIR"
.SD
A Infinite Impulse Response (IIR) filter.
Coefficients are in the "numerator" and "denominator", both start
with z^0 terms and decrease in powers of z.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.9 "12/8/92"
.AL "Kennard White"
.IH
.NE
\fIsignalIn\fR (float)
.PE
.OH
.NE
\fIsignalOut\fR (float)
.PE
.SH
.NE
\fIgain\fR (FloatState): Gain.
.DF "1"
.NE
\fInumerator\fR (FloatArrayState): Numerator coefficients.
.DF ".5 .25 .1"
.NE
\fIdenominator\fR (FloatArrayState): Denominator coefficients.
.DF "1 .5 .3"
.NE
\fIstate\fR (FloatArrayState): State.
.DF "0"
.ET
.LD
.PP
This star implements a infinite-impulse response filter of arbirary order.
The parameters of the star specify H(z), the Z-transform of an
impulse response h(n).  The output of the star is the convolution
of the input with h(n).
.PP
The transfer function implemented is of the form H(z)=G*N(1/z)/D(1/z),
where N() and D() are polynomials.  The state "gain" specifies G, and
the state arrays "numerator" and "denominator" specify N and D, respectively.
Both arrays start with z^0 terms and decrease in powers of z (increase in
powers of 1/z).  Note that the leading term of D is *not* ommitted.
.PP
Note that the numerical finite precision noise increases with the filter order.
It is often desirable to expand the filter into a parallel or cascade form.
.SA
FIR and
Biquad.
.ES
