.\" documentation file generated from SDFFIRCx.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "FIRCx"
.SD
A complex Finite Impulse Response (FIR) filter.
Coefficients are in the "taps" state variable.
Default coefficients give an 8th order, linear phase, lowpass filter.
To read coefficients from a file, use the syntax: "<fileName".
Real and imaginary parts should be paired with parentheses, e.g. (1.0, 0.0).
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.9 "12/8/92"
.AL "E. A. Lee"
.IH
.NE
\fIsignalIn\fR (complex)
.PE
.OH
.NE
\fIsignalOut\fR (complex)
.PE
.SH
.NE
\fItaps\fR (ComplexArrayState): Filter tap values.
.DF "(-.040609,0.0) (-.001628,0.0) (.17853,0.0) (.37665,0.0)" "(.37665,0.0) (.17853,0.0) (-.001628,0.0) (-.040609,0.0)"
.NE
\fIdecimation\fR (IntState): Decimation ratio.
.DF "1"
.NE
\fIdecimationPhase\fR (IntState): Downsampler phase.
.DF "0"
.NE
\fIinterpolation\fR (IntState): Interpolation ratio.
.DF "1"
.ET
.LD
.pp
ComplexFIR implements a finite-impulse response filter with multirate
capability.  The default coefficients correspond to a real eighth order,
equiripple, linear-phase, lowpass filter.
.Id "FIR filter, complex"
.Id "filter, FIR, complex"
The 3dB cutoff frequency at about 1/3
of the Nyquist frequency.  To load filter coefficients from a file,
simply replace the default coefficients with the string "<filename".
The real and imaginary parts should be enclosed in parenthesis,
as follows: (0.1,0.3).
.pp
It is advisable to use an absolute path name as part of the file name,
especially if you are using the graphical interface.
This will allow the filter to work as expected regardless of
the directory in which the ptolemy process actually runs.
It is best to use tildes in the filename.
.pp
When the \fIdecimation\fP (\fIinterpolation\fP)
state is different from unity, the filter behaves exactly
as it were followed (preceded) by a DownSample (UpSample) star.
However, the implementation is much more efficient than
it would be using UpSample and DownSample stars;
a polyphase structure is used internally, avoiding unnecessary use
of memory and unnecessary multiplication by zero.
Arbitrary sample-rate conversions by rational factors can
be accomplished this way.
.pp
To design a filter for a multirate system, simply assume the
sample rate is the product of the interpolation parameter and
the input sample rate, or equivalently, the product of the decimation
parameter and the output sample rate.
.Ir "multirate filter design"
.Ir "filter, multirate"
In particular, considerable care must be taken to avoid aliasing.
Specifically, if the input sample rate is f,
then the filter stopband should begin before f/2.
If the interpolation ratio is i, then f/2 is a fraction 1/2i
of the sample rate at which you must design your filter.
.pp
The \fIdecimationPhase\fP parameter is somewhat subtle.
It is exactly equivalent the phase parameter of the DownSample star.
Its interpretation is as follows; when decimating,
samples are conceptually discarded (although a polyphase structure
does not actually compute the discarded samples).
If you are decimating by a factor of three, then you will select
one of every three outputs, with three possible phases.
When decimationPhase is zero (the default),
the latest (most recent) samples are the ones selected.
The decimationPhase must be strictly less than
the decimation ratio.
.pp
For more information about polyphase filters, see F. J. Harris,
"Multirate FIR Filters for Interpolating and Desampling", in
\fIHandbook of Digital Signal Processing\fR, Academic Press, 1987.
.SA
FIR,
Biquad,
UpSample,
DownSample and
analytic.
.ES
