.\" documentation file generated from SDFFFTCx.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "FFTCx"
.SD
Complex Fast Fourier transform.
Parameter "order" (default 8) is the log, base 2, of the transform size.
Parameter "size" (default 256) is the number of samples read (<= 2^order).
Parameter "direction" (default 1) is 1 for forward, -1 for inverse FFT.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.14 "12/8/92"
.AL "J. T. Buck"
.IH
.NE
\fIinput\fR (complex)
.PE
.OH
.NE
\fIoutput\fR (complex)
.PE
.SH
.NE
\fIorder\fR (IntState): Log base 2 of the transform size.
.DF "8"
.NE
\fIsize\fR (IntState): Number of input samples to read.
.DF "256"
.NE
\fIdirection\fR (IntState): = 1 for forward, = -1 for inverse.
.DF "1"
.ET
.LD
A number of input samples given by the parameter \fIsize\fR will
be consumed at the input, zero-padded if necessary to make $2 sup order$
samples, and transformed using a fast Fourier transform algorithm.
.Id "FFT, complex"
.Id "fast Fourier transform, complex"
.Id "Fourier transform, fast, complex"
If \fIdirection\fR is 1, then the forward Fourier transform is computed.
If \fIdirection\fR is -1, then the inverse Fourier transform is computed.
.lp
Note a single firing of this star consumes \fIsize\fR inputs
and produces $2 sup order$ outputs.
This must be taken into account when determining for how many iterations
to run a universe.
For example, to compute just one FFT, only one iteration should be run.
.lp
\fBBugs\fR: the routine currently used (from Gabriel) recomputes trig
.Ir "Gabriel"
functions for each term, instead of using a table.  Instead,
FFTCx::setup() should compute a table of appropriate size to save
time.  This has no effect, obviously, if only one transform
is performed.
.ES
