.\" documentation file generated from SDFDTFT.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "DTFT"
.SD
Discrete-time Fourier transform.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.8 "12/8/92"
.AL "E. A. Lee"
.IH
.NE
\fIsignal\fR (complex): Signal to be transformed.
.NE
\fIomega\fR (float): Frequency values at which to sample the transform.
.PE
.OH
.NE
\fIdtft\fR (complex): The samples of the transform.
.PE
.SH
.NE
\fIlength\fR (IntState): The length of the input signal.
.DF "8"
.NE
\fInumberOfSamples\fR (IntState): The number of samples of the transform to output.
.DF "128"
.NE
\fItimeBetweenSamples\fR (FloatState): The time between input samples (T).
.DF "1.0"
.ET
.LD
This star computes arbitrary samples of the discrete-time Fourier
transform of a finite length sequence.
.Id "discrete time Fourier transform"
.Id "Fourier transform, discrete time"
.Ir "spectral estimation"
The \fIsignal\fR input is the signal to be transformed.
The number of input samples consumed is given by \fIlength\fR.
Let these be written $a(0), ~ ... ~ ,~ a(L-1)$, where
$L$ is the \fIlength\fR.
Then the output is
.EQ
A ( j omega ) ~=~
{ sum from k=0 to L-1 a(k) e sup {- j omega k T} }
.EN
where $T$ is the time between samples (\fItimeBetweenSamples\fR).
The number of samples produced at the output is determined
by the \fInumberOfSamples\fR parameter.
The values of $omega$ at which samples are taken are provided
by the \fIomega\fR input.  Hence, any frequency range or ranges
can be examined at any desired resolution, and samples need not
be taken at uniform intervals.
Note that $omega ~=~ 2 pi / T$ is
the sampling frequency.
.SA
FFTCx.
.ES
