.\" documentation file generated from SDFBurg.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Burg"
.SD
Burg's algorithm.  The lp output receives the linear prediction coefficients
and the refl output receives reflection coefficients.  The errPower output
gets the power of the prediction error at each stage.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.12 "12/8/92"
.AL "E. A. Lee and J. T. Buck"
.IH
.NE
\fIinput\fR (float): Input random process.
.PE
.OH
.NE
\fIlp\fR (float): AR coefficients output.
.NE
\fIrefl\fR (float): Lattice predictor coefficients output.
.NE
\fIerrPower\fR (float): Prediction error power.
.PE
.SH
.NE
\fIorder\fR (IntState): The number of reflection coefficients to generate.
.DF "8"
.NE
\fInumInputs\fR (IntState): The number of inputs used to estimate the model.
.DF "64"
.ET
.LD
.pp
This star uses Burg's algorithm to estimate the reflection coefficients
and AR parameters of an input random process.
.Id "Burg's algorithm"
.Ir "linear prediction"
.Ir "spectral estimation, maximum entropy"
.Ir "maximum entropy spectral estimation"
The number of inputs looked at is given by the \fInumInputs\fR parameter
and the order of the AR model is given by the \fIorder\fR parameter.
.Ir "autoregressive model"
.Ir "AR model"
The order specifies how many outputs appear on the \fIlp\fR and
\fIrefl\fR output portholes.
These outputs are, respectively, the autoregressive (AR) parameters
(also called the linear predictor parameters),
and the reflection coefficients.
.Ir "reflection coefficients"
.Ir "coefficients, reflection"
.pp
Note that the definition of reflection coefficients is not quite
universal in the literature.
The reflection coefficients in references [2] and [3]
are the negative of the ones generated by this star,
which correspond to the definition in most other texts,
and to the definition of partial-correlation (PARCOR)
coefficients in the statistics literature.
.Ir "partial correlation coefficients"
.Ir "coefficients, partial correlation"
.Ir "PARCOR"
.pp
The \fIerrPower\fR output is the power of the prediction error
as a function of the model order.  There are $order+1$ output samples,
where the first corresponds to the prediction error of a zero-th
order predictor.  This is simply an estimate of the input signal power.
.UH REFERENCES
.ip [1]
J. Makhoul, "Linear Prediction: A Tutorial Review",
\fIProc. IEEE\fR, Vol. 63, pp. 561-580, Apr. 1975.
.ip [2]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.ip [3]
S. Haykin, \fIModern Filters\fR, MacMillan Publishing Company,
New York, 1989.
.SA
LevDur,
linearPrediction and
powerSpectrum.
.ES
