.\" documentation file generated from SDFBlockFIR.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "BlockFIR"
.SD
An FIR filter with coefficients externally supplied.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.9 "12/8/92"
.AL "E. A. Lee"
.IH
.NE
\fIsignalIn\fR (float)
.NE
\fIcoefs\fR (float)
.PE
.OH
.NE
\fIsignalOut\fR (float)
.PE
.SH
.NE
\fIblockSize\fR (IntState): Number of inputs that use each each coefficient set.
.DF "128"
.NE
\fIorder\fR (IntState): Number of new coefficients to read each time.
.DF "16"
.NE
\fIdecimation\fR (IntState): Decimation ratio.
.DF "1"
.NE
\fIdecimationPhase\fR (IntState): Downsampler phase.
.DF "0"
.NE
\fIinterpolation\fR (IntState): Interpolation ratio.
.DF "1"
.ET
.LD
.pp
This star implements an FIR filter with coefficients that
are periodically updated
from the outside.
.Id "filter, FIR, block"
.Id "FIR filter, block"
The \fIblockSize\fR parameter tells how often
the updates occur.  It is an integer specifying how may input samples
should be processed using each set of coefficients.  The \fIorder\fR
parameter tells how many coefficients there are.
The same interpolation and decimation of the FIR star is supported.
.pp
Unfortunately, it proves not too convenient to derive this star from FIR
because of the changes in the way the inputs and outputs are handled.
Hence, much of the code here is quite similar to that in the FIR star.
.SA
FIR.
.ES
