.\" documentation file generated from SDFBlockAllPole.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "BlockAllPole"
.SD
An all pole filter with coefficients externally supplied.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 2.10 "12/8/92"
.AL "E. A. Lee"
.IH
.NE
\fIsignalIn\fR (float)
.NE
\fIcoefs\fR (float): Coefficients of the denominator polynomial
.PE
.OH
.NE
\fIsignalOut\fR (float)
.PE
.SH
.NE
\fIblockSize\fR (IntState): Number of inputs that use each each coefficient set.
.DF "128"
.NE
\fIorder\fR (IntState): Number of new coefficients to read each time.
.DF "16"
.ET
.LD
.pp
This star implements an all pole filter with coefficients that
are periodically updated
.Id "allpole filter, block"
.Id "filter, allpole, block"
.Id "filter, IIR, block"
from the outside.  The \fIblockSize\fR parameter tells how often
the updates occur.  It is an integer specifying how may input samples
should be processed using each set of coefficients.  The \fIorder\fR
parameter tells how many coefficients there are.
The transfer function of the filter is
.EQ
H(z) ~=~ 1 over { 1 ~-~ z sup -1 D(z) }
.EN
where $D(z)$ is the specified by the externally supplied coefficients.
Let
.EQ
D(z) ~=~ d sub 1 ~+~ d sub 2 z sup -1 ~+~ ... ~+~ d sub M z sup M-1 ~.
.EN
Then $d sub i$ is the $i sup th$ coefficient supplied on the
\fIcoefs\fR input.
.pp
No decimation or interpolation is supported.
.SA
FIR and
BlockFIR.
.ES
