.\" documentation file generated from SDFAutocor.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Autocor"
.SD
Estimates an autocorrelation by averaging input samples.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 2.8 "12/8/92"
.AL "E. A. Lee"
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fInoInputsToAvg\fR (IntState): Number of input samples to average.
.DF "256"
.NE
\fInoLags\fR (IntState): Number of autocorrelation lags to output.
.DF "64"
.NE
\fIunbiased\fR (IntState): If YES, the estimate will be unbiased.
.DF "YES"
.ET
.LD
.pp
Estimates a certain number of samples of the autocorrelation of the input
.Id "autocorrelation"
by averaging a certain number of input samples.  The number of outputs
is twice the number of lags requested.  This makes the output almost
symmetric (discard the last sample to get a perfectly symmetric output).
.pp
If the parameter \fIunbiased\fR is NO, then
the autocorrelation estimate is
.Id "unbiased autocorrelation"
.EQ
r hat (k) ~=~ 1 over N sum from n=0 to N-1-k x(n)x(n+k)
.EN
for $k ~=~ 0, ... , ~ p$, where $N$ is the number of inputs to average
(\fInoInputsToAvg\fR) and $p$ is the number of lags to estimate (\fInoLags\fR).
This estimate is biased because the outermost lags have fewer than $N$
.Id "biased autocorrelation"
terms in the summation, and yet the summation is still normalized by $N$.
.pp
If the parameter \fIunbiased\fR is YES (the default), then the estimate is
.EQ
r hat (k) ~=~ 1 over N-k sum from n=0 to N-1-k x(n)x(n+k) ~.
.EN
In this case, the estimate is unbiased.
However, note that the unbiased estimate does not guarantee
a positive definite sequence, so a power spectral estimate based on this
autocorrelation estimate may have negative components.
.Ir "spectral estimation"
.ES
