.\" @(#)SDFADPCMCoder.t	1.1	12/17/92
.NA ADPCMCoder
.SD
This galaxy uses the LMS
star to implement Adaptive Differential PCM.  Both the quantized
and unquantized prediction-error signals are available as outputs.
.SE
.LO "SDF communications palette (galaxy)"
.DM SDF SDFGalaxy
.SV 1.1 12/17/92
.AL "G.S. Walter"
.Sr LMS SDF
.Sr Quantizer SDF
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fId(n)\fR (float)
.NE
\fIu(n)\fR (float)
.PE
.SH
.NE
\fIstepSize\fR (FloatState):  Step size used for updating filter taps in LMS algorithm.
.DF "1.0E-12"
.NE
\fIorder\fR (IntState):  Specifies order of LMS prediction-error filter.
.DF "16"
.NE
\fIrange\fR (FloatState):  Positive range of prediction-error coefficients for scaling since quantization is based on interval [-1.0, 1.0].
.DF "800"
.ET
.LD
This galaxy performs Adaptive Differential PCM
using a feed-back-around quantizer structure.
The \fIu(n)\fR output may be fed into the
.c ADPCMDecoder
galaxy for decoding.   A user may choose to
utilize the
.c ADPCMToBits
galaxy which will convert the 16-level output
\fIu(n)\fR into an appropriate stream of bits
mimicking a 32 kbps circuit for an 8 kHz-voice input.
The bit stream may be converted back to floats using
.c ADPCMFromBits
which could subsequently be decoded using
.c ADPCMDecoder.
.pp
A \fId(n)\fR output has also been made
available in this galaxy.  This allows
the user to see the unquantized prediction error.
It is interesting to note that without loss of information
between the
.c ADPCMCoder
and the
.c ADPCMDecoder,
the noise found in the decoded signal is identical
to the quantization noise injected by the coder.  The
quantization noise, in this galaxy, is equal to
\fId(n) - u(n)\fR.
.SA
.c ADPCMDecoder
.c ADPCMToBits
.c ADPCMFromBits
.ES
