.\" documentation file generated from DEUDCounter.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "UDCounter"
.SD
This is up/down counter.
The processing order of the ports is: countUp -> countDown -> demand -> reset.
Specifically, all simultaneous "countUp" inputs are processed.
Then all simultaneous "countDown" inputs are processed.
If there are multiple simultaneous "demand" inputs, all but the first
are ignored.  Only one output will be produced.
.SE
.LO "DE main library"
.DM DE DEStar
.SV 1.9 "12/8/92"
.AL "Soonhoi Ha"
.IH
.NE
\fIcountUp\fR (anytype)
.NE
\fIcountDown\fR (anytype)
.NE
\fIreset\fR (anytype)
.NE
\fIdemand\fR (anytype): Stimulate an output.
.PE
.OH
.NE
\fIoutput\fR (int)
.PE
.SH
.NE
\fIresetValue\fR (IntState): Initial value for the counter.
.DF "0"
.ET
.LD
Upon receiving a "countUp" or "countDown" input, an internal counter is
incremented or decremented.
When a "reset" input is received, the count is reset to "resetValue".
A "count" output is generated when a "demand" input is received.
When "demand" and "reset" particles arrive at the same time,
the output is generated before the count is reset.
The "countUp(or Down)" input is processed before the "demand" input,
so if there are identical time stamps on these inputs, the increment
and/or decrement will occur before the output is produced.
If successive inputs arrive with the same time stamp on any input path,
they are all processed.
Special cases, such as an up only counter, can be realized by connecting
a Null star to the unneeded inputs.
.ES
