.\" documentation file generated from DETestLevel.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "TestLevel"
.SD
This star detects threshold crossings if "crossingsOnly" is TRUE.
Otherwise, it simply compares the input against the "threshold".

If "crossingsOnly" is TRUE, then: 
(1) A TRUE is sent to "output" when the "input" particle exceeds or
    equals the "threshold" value, having been previously smaller.
(2) A FALSE is sent when the "input" particle is smaller than
    "threshold" having been previously larger.
Otherwise, no output is produced.

If "crossingsOnly" is FALSE, then a TRUE is sent to "output"
whenever any "input" particle greater than or equal to "threshold"
is received, and a FALSE is sent otherwise.
.SE
.LO "DE main library"
.DM DE DEStar
.SV 1.5 "12/8/92"
.AL "Soonhoi Ha and Edward Lee"
.IH
.NE
\fIinput\fR (float): Value to be compared against the threshold.
.PE
.OH
.NE
\fIoutput\fR (int): Indicates level crossings or result of compare.
.PE
.SH
.NE
\fIthreshold\fR (FloatState): The level for comparison against input particles.
.DF "10"
.NE
\fIcrossingsOnly\fR (IntState): If TRUE, outputs occur only on level crossings.
.DF "TRUE"
.ET
.LD
When "crossingsOnly" is TRUE,
this star internally remembers its previous outputs so that successive
identical outputs are not produced.  The output will always be an
alternating TRUE/FALSE stream.  In this case,
The first output will always be TRUE, and will occur the first time
the input exceeds the threshold.
.ES
