.\" documentation file generated from DEPriorityQueue.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "PriorityQueue"
.SD
A priority queue.
Inputs have priorities according to the number of the input, with
"inData#1" having highest priority, "inData#2" being next, etc.
When a "demand" is received, outputs are produced by selecting first
based on priority, and then based on time of arrival, using a FIFO policy.
A finite total capacity can be specified by setting the "capacity"
parameter to a positive integer.
When capacity is reached, further inputs are sent to the "overflow"
output, and not stored.
The "numDemandsPending" and "consolidateDemands" states have the same
meaning as in other Queue stars.
The size of the queue is sent to the "size" output whenever an "inData"
or "demand" event is processed.
.SE
.LO "DE main library"
.DM DE DEStar
.SV 1.5 "12/8/92"
.AL "Soonhoi Ha and E. A. Lee"
.IH
.NE
\fIdemand\fR (anytype): Demand an ouput.
.NE
\fIinData\fR (multiple), (anytype): Particles to be queued.
.PE
.OH
.NE
\fIoutData\fR (ANYTYPE): Particles that are de-queued on demand.
.NE
\fIsize\fR (int): The current number of particles stored.
.NE
\fIoverflow\fR (ANYTYPE): Arrival data that can not be queued due to capacity limit.
.PE
.SH
.NE
\fIcapacity\fR (IntState): Maximum total number of particles. If <0, capacity is infinite.
.DF "-1"
.NE
\fInumDemandsPending\fR (IntState): Number of demands that have not yet stimulated outputs.
.DF "1"
.NE
\fIconsolidateDemands\fR (IntState): If FALSE, every demand eventually stimulates an output.
.DF "TRUE"
.ET
.LD
This star queues input particles and produces output particles on demand.
The inputs are assigned priorities so that when an output is demanded,
if any particle from \fIinData#1\fR is available, it
will be sent to the output.  If several particles from
\fIinData#1\fR are available, a FIFO policy is used.
Only if the queue for \fIinData#1\fR is empty
will the queue for \fIinData#2\fR be examined.
This means that later arrivals on \fIinData#1\fR may go to the output before
earlier arrivals on \fIinData#2\fR.
.pp
The first particle to arrive at an input is always passed directly
to the output, unless \fInumDemandsPending\fR is initialized to 0.
If several particles arrive first with the same time stamp, the highest
priority particle will go to the output.
.pp
If \fIconsolidateDemands\fR is set to TRUE (the default),
then \fInumDemandsPending\fR is not permitted to rise above unity.
This means that
if multiple \fIdemand\fR particles with the same time stamp
are waiting at the \fIdemand\fR input, they are
consolidated into a single demand, and only one output is produced.
As usual, if a \fIdemand\fR input arrives between the time that the queue
goes empty and the next arrival of a data input, it enables
the next \fIinData\fR particle to pass immediately to the output by
setting the state \fInumDemandsPending\fR to unity.
But if more than one \fIdemand\fR event arrives in this time period, the
effect is the same as if only one such event had arrived.
.pp
If \fIconsolidateDemands\fR is set to FALSE, then every \fIdemand\fR input
will eventually stimulate an output, even if successive demands arrive
when the queue is empty, and even if successive demands arrive with the
same time stamp.
.pp
A total capacity limit is specified.
This is the limit on the total number of particles that the star
may store from one firing to the next, regardless of which input they came from.
Note that storage is allocated dynamically, so a large capacity
does not necessarily imply a large storage usage.
When the capacity is reached, all further inputs will be routed
to the \fIoverflow\fR output
until a demand input makes space in the star.
To make the capacity infinite, simply enter a negative number.
.pp
Like the
.c FIFOQueue
star, this star de-queues particles on demand.
Data outputs are produced when a demand input arrives, if the any of the
queues has particles in it.
If all queues are empty, no data output is produced
until the next time a data input arrives.
That next data input will be directed to the data output immediately.
Any intervening demand inputs (between the time that the queues
go empty and the next arrival of a data input) are ignored.
.pp
Each time a data or demand input arrives, the size of the queue
after processing the input is sent to the \fIsize\fR output.
.SA
FIFOQueue.
.ES
