.\" documentation file generated from DEPCMVoiceRecover.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "PCMVoiceRecover"
.SD
This star inputs a stream of SeqATMCell objects.  All the
information bits in objects received with correct sequence
numbers are sent to 'output'.

If a missing SeqATMCell object is detected, this star sends the most
recent 8 * 'tempSize' received bits to the 'temp' output, and the
most recent (8 * 'searchWindowSize' + 'numInfoBits') received bits
to the 'window' output.

The bits output on the 'window' and 'temp' outputs can be used by
the 'PatternMatch' galaxy to implement lost-speech recovery.
.SE
.LO "DE main palette"
.DM DE DEStar
.SV 1.5 "12/8/92"
.AL "GSWalter"
.IH
.NE
\fIinput\fR (message)
.NE
\fIsubIn\fR (message)
.PE
.OH
.NE
\fItemp\fR (int)
.NE
\fIwindow\fR (int)
.NE
\fIoutput\fR (int)
.PE
.SH
.NE
\fInumInfoBits\fR (IntState): number of information bits per cell <= 384
.DF "384"
.NE
\fIsearchWindowSize\fR (IntState): number of samples <= 4*numInfoBits/8
			and >= 3*numInfoBits/8 with which to
			search and retrieve match in SDF domain
.DF "176"
.NE
\fItempSize\fR (IntState): number of samples <= 48 which act as a guide
			in determining missing packet samples
.DF "32"
.ET
.LD
.pp
This star performs a specific function related to a
voice-packet interpolation technique for PCM encoded
data.  On its \fIinput\fR port, this star reads in
.c SeqATMCell
types which have a field containing a packet sequence
number.  The sequence number is read and it is determined
whether or not a packet has been dropped during network
transmission.  If the missing packet is one of the
first five
.c SeqATMCell
s to be sent over the network, this star will substitutue
all zero bits for the bits which were lost during
transmission.  These bits are sent through the \fIoutput\fR
port.  If the dropped packet was not one of the first
five, a pattern matching technique is used to determine
the proper bits to substitute for those lost.  This is
performed as follows:
.pp
Say the packet six was found to be missing by this
star after it sees a
.c SeqATMCell
numbered seven immediately following a
.c SeqATMCell
numbered five.  This star will then output a string
of bits on its \fItemp\fR port of size \fItempSize\fR
* 8.  These bits describe the first \fItempSize\fR
samples immediately preceeding the missing packet.  Likewise,
\fIsearchWindowSize\fR * 8 + \fInumInfoBits\fR bits
are sent through the \fIwindow\fR port.  These bits describe
the
.c SeqATMCell
immediately preceeding the lost packet as well as the
previous \fIsearchWindowSize\fR samples before that.
In this example of a missing sixth packet, this means
that the \fItemp\fR bits will come from the end of
packet five and the \fIwindow\fR bits will include
all of packets 5, 4, 3, 2, and a portion of the
end of packet 1 (Note restriction on \fIsearchWindowSize\fR).
These bits are converted to samples in an SDF domain
wormhole and a cross correlation is performed between the
\fItemp\fR and the \fIwindow\fR determining the best
match i.e., largest cross correlation value.  This SDF
galaxy will take the \fInumInfoBits\fR / 8 samples
from the \fIwindow\fR samples following the \fIwindow\fR's
best match with the \fItemp\fR samples. These samples
are then encoded, loaded into a
.SeqATMCell
and sent back to the DE domain where they enter the
\fIsubIn\fR port of this star.  This star unloads
the bits from this
.c SeqATMCell
and outputs them in their proper order on the \fIoutput\fR
port.  If more than one packet was missing, this star
will repeat the derived packet enough times to fill the
void.
.UH REFERENCES
Goodman, J., LockHart, G., Wasem, O., and Wong, W.,
"Waveform Substitution Techniques for Recovering
Missing Speech Segments in Packet Voice Communications,"
\fIIEEE Trans. on ASSP\fR, vol ASSP-34, no. 6, pp. 1440-
1448, December 1986.
.ES
