.\" documentation file generated from DEMeasureDelay.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "MeasureDelay"
.SD
Measure the time difference between the first arrival
and the second arrival of an event with the same value.
The second arrival and the time difference are each sent to outputs.
.SE
.LO "DE main library"
.DM DE DEStar
.SV 2.6 "12/8/92"
.AL "Soonhoi Ha"
.IH
.NE
\fIinput\fR (ANYTYPE)
.PE
.OH
.NE
\fItimeDiff\fR (float)
.NE
\fIoutput\fR (ANYTYPE)
.PE
.LD
This star measures the time difference of the first and second arrival of
particles with the same value on the same input.
When the first particle with a particular data value
arrives, it is stored.
When the second particle with a particular data value arrives,
it is matched to the first arrival in storage, and
a \fItimeDiff\fR
output is generated with value equal to the arrival time difference.
The data value itself is also
sent to the \fIoutput\fR port upon the second arrival.
.pp
Packets are only considered to have the "same value" if they are copied
from a common source (so that each packet shares the same common PacketData
structure).  This suffices for common uses of MeasureDelay where the
same packet is routed through a delay-free path and also a path with delay.
.ES
