.\" documentation file generated from DEHandShake.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "HandShake"
.SD
Cooperates with a (possibly preemptive) arbitrator through the
"request" and "grant" controls.  "Input" particles are passed to
"output", and an "ackIn" particle must be received before the next
"output" can be sent.  This response is made available on "ackOut".
.SE
.LO "DE main library"
.DM DE DEStar
.SV 1.7 "12/8/92"
.AL "T.M. Parks"
.IH
.NE
\fIinput\fR (anyType)
.NE
\fIackIn\fR (anyType): Acknowledges receipt of most recent "output" particle.
.NE
\fIgrant\fR (int): Enables and disables sending of "output" particles.
.PE
.OH
.NE
\fIoutput\fR (ANYTYPE)
.NE
\fIackOut\fR (ANYTYPE): Response to most recent "output" particle.
.NE
\fIrequest\fR (int): Indicates presence or absence of "input" particles.
.PE
.LD
A \fI request \fP TRUE is generated in response to a new \fI input.\fP
After a \fI grant \fP TRUE response is received, the \fI input \fP will
be passed to the \fI output.\fP  After this \fI output \fP is
acknowledged by an \fI ackIn \fP response, the next \fI input \fP is
passed to the \fI output \fP if it is available, and the process
repeats.  If no new \fI input \fP is available when the \fI ackIn \fP
is received, a \fI request \fP FALSE is generated.  When the \fI grant \fP
FALSE response is received, the star reverts to its original idle state.
.lp
Note that the star will not generate any spurious outputs on either \fI
output \fP or \fI request \fP while it is waiting for a response on
the \fI grant \fP or \fI ackIn \fP inputs.  Also, only those \fI ackIn \fP
particles received in response to an \fI output \fP will be sent to \fI
ackOut.\fP
.ES
