.\" documentation file generated from DEFilter.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Filter"
.SD
First order AR filter.
.SE
.LO "DE main library"
.DM DE DEStar
.SV 2.4 "11/25/92"
.AL "E. A. Lee"
.IH
.NE
\fIclock\fR (anytype)
.NE
\fIdata\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fIdecay\fR (FloatState): Exponential decay parameter.
.DF "0.9"
.NE
\fItau\fR (FloatState): Time of the latest data input event.
.DF "0.0"
.NE
\fIstate\fR (FloatState): State of the filter as of the latest input event.
.DF "0.0"
.ET
.LD
This star filters the input signal with a first-order, AR impulse response.
The data input is interpreted as weighted impulses.  An output is triggered
by a clock input.  Assuming a clock input event triggers the star at time $T$,
the output is:
.EQ
y(T) ~=~ d sup {(T ~-~ tau )} s( tau )
.EN
where $tau$ is the time of the latest data input event, $s( tau )$ is the
state of the filter at time $tau$,
and $d$ is the exponential decay parameter.
Each time a data input arrives, the state is updated
as follows:
.EQ
s( tau ) ~=~ i( tau ) ~+~ d sup {( tau ~-~ tau prime )} s( tau prime )
.EN
where $tau prime$ is the time of the previous data input event,
and $i( tau )$ is the data input.
.ES
