.\" documentation file generated from CGCWaveForm.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "WaveForm"
.SD
Output a waveform as specified by the array state "value" (default "1 -1").
You can get periodic signals with any period, and can halt a simulation
at the end of the given waveform.  The following table summarizes the
capabilities:

 haltAtEnd   periodic   period    operation
 ------------------------------------------------------------------------
 NO          YES        0         The period is the length of the waveform
 NO          YES        N>0       The period is N
 NO          NO         anything  Output the waveform once, then zeros
 YES         anything   anything  Stop after outputting the waveform once

The first line of the table gives the default settings.
.SE
.LO "CGC main library"
.DM CGC CGCStar
.SV 1.5 "12/11/92"
.AL "S. Ha"
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fIvalue\fR (FloatArrayState): One period of the output waveform.
.DF "1 -1"
.NE
\fIhaltAtEnd\fR (IntState): Halt the run at the end of the given data.
.DF "NO"
.NE
\fIperiodic\fR (IntState): Output is periodic if "YES" (nonzero).
.DF "YES"
.NE
\fIperiod\fR (IntState): If greater than zero, gives the period of the waveform.
.DF "0"
.NE
\fIpos\fR (IntState)
.DF "0"
.NE
\fIsize\fR (IntState)
.DF "0"
.ET
.LD
This star may be used to read a file by simply setting "value" to
something of the form "< filename".  The file will be read completely
and its contents stored in an array.  The size of the array is currently
limited to 20,000 samples.  To read longer files, use the 
.c ReadFile
star.  This latter star reads one sample at a time, and hence also
uses less storage.
.Id "file read"
.Id "waveform from file"
.Id "reading from a file"
.Ir "halting a simulation"
.Ir "simulation, halting"
.ES
