.\" documentation file generated from CGCLMS.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LMS"
.SD
Adaptive filter using LMS adaptation algorithm.
Initial coefficients are in the "taps" state variable.
Default initial coefficients give an 8th order, linear phase
lowpass filter.  To read default coefficients from a file,
replace the default coefficients with "<fileName".
Supports decimation, but not interpolation.
.SE
.LO "cgc main library"
.DM CGC CGCFIR
.SV 1.8 "12/8/92"
.AL "Soonhoi Ha"
.IH
.NE
\fIerror\fR (float)
.PE
.SH
.NE
\fIstepSize\fR (FloatState): Adaptation step size.
.DF "0.01"
.NE
\fIerrorDelay\fR (IntState): Delay in the update loop.
.DF "1"
.NE
\fIsaveTapsFile\fR (StringState): File to save final tap values.
.DF ""
.ET
.LD
When correctly used, this filter will adapt to try to minimize
the mean-squared error of the signal at its \fIerror\fR input.
In order for this to be possible, the output of the filter should
be compared (subtracted from) some reference signal to produce
an error signal.
That error signal should be fed back to the \fIerror\fR input.
The \fIdelay\fR parameter must equal the total number of delays
in the path from the output of the filter back to the error input.
This ensures correct alignment of the adaptation algorithm.
The number of delays must be greater than zero or the dataflow
graph will deadlock.
The adaptation algorithm used is the well-known LMS, or stochastic-gradient
algorithm.
.IE "stochastic gradient algorithm"
.lp
If the \fIsaveTapsFile\fR string is non-null, a file will
be created by the name given by that string, and the final tap values
will be stored there after the run has completed.
.SA
FIR.
.ES
