.\" documentation file generated from CGCIntegrator.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Integrator"
.SD
An integrator with leakage, limits, and reset.
With the default parameters, input samples are simply accumulated,
and the running sum is the output.  To prevent any resetting in the
middle of a run, connect a d.c. source with value 0.0 to the "reset"
input.  Otherwise, whenever a non-zero is received on this input,
the accumulated sum is reset to the current input (i.e. no feedback).

Limits are controlled by the "top" and "bottom" parameters.
If top <= bottom, no limiting is performed (default).  Otherwise,
the output is kept between "bottom" and "top".  If "saturate" = YES,
saturation is performed.  If "saturate" = NO, wrap-around is performed
(default).  Limiting is performed before output.

Leakage is controlled by the "feedbackGain" state (default 1.0).
The output is the data input plus feedbackGain*state, where state
is the previous output.
.SE
.LO "CGC main library"
.DM CGC CGCStar
.SV 1.3 "12/8/92"
.AL "E. A. Lee"
.IH
.NE
\fIdata\fR (float)
.NE
\fIreset\fR (int)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fIfeedbackGain\fR (FloatState): The gain on the feedback path.
.DF "1.0"
.NE
\fItop\fR (FloatState): The upper limit.
.DF "0.0"
.NE
\fIbottom\fR (FloatState): The lower limit.
.DF "0.0"
.NE
\fIsaturate\fR (IntState): Saturate if YES, wrap around otherwise.
.DF "YES"
.NE
\fIstate\fR (FloatState): An internal state.
.DF "0.0"
.ET
.LD
.Id "filter, integrator"
.ES
