.\" documentation file generated from CG96Window.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Window"
.SD
Apply a window function of length N and of the specified
type to the input block.
.SE
.LO "CG96 demo library"
.DM CG96 CG96Star
.SV 1.5 "12/8/92"
.AL "Chih-Tsung Huang (ported from gabriel)"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fIname\fR (StringState): Name of the window function to generate.
.DF "hamming"
.NE
\fIlength\fR (IntState): Length of the window function to produce.
.DF "16"
.NE
\fIwindowSequence\fR (FloatArrayState): internal
.DF "0.1 0.2 0.3 0.4"
.NE
\fIcoef\fR (FloatArrayState): internal
.DF "0"
.NE
\fIdcVal\fR (FloatState): internal
.DF "0"
.NE
\fIX\fR (IntState): internal
.DF "0"
.ET
.LD
.PP
The star windows a block of input of length \fIlength\fR.
If \fIname\fR is "special",
the block of data is scaled by the coefficients given by
\fIwindowSequence\fR.
The sequence is zero-padded or truncated to \fIlength\fR as necessary.
Otherwise, the block of data is scaled by the coefficients of the
type of window specified by \fIname\fR.
.PP
\fIname\fR can be one of the following 4 types:
.PP
"triangular" or "bartlett" - given by
.IP
W(n) = length/2 + sgn(n - length/2) * (n - length/2), where sgn is
the signum function
.PP
"hamming" - given by
.IP
W(n) = 0.54 - 0.46*cos(2*pi*n/(length-1))
.PP
"hanning" - given by
.IP
W(n) = sqr(sin(pi*n/(length-1))), where sqr(x) = x^2
.PP
"blackman"
.IP
W(n) = 0.42 - 0.5*cos(2*pi*n/(length-1)) + 0.08*cos(4*pi*n/(length-1))
.ES
