.\" documentation file generated from CG96Log.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Log"
.SD
Logrithm, out=log(in)
.SE
.LO "CG96 nonlinear functions library"
.DM CG96 CG96Star
.SV 1.8 "12/1/92"
.AL "Chih-Tsung Huang (ported from Gabriel)"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fIbase\fR (FloatState): base value
.DF "2.7182818284"
.NE
\fIconstant\fR (FloatArrayState): internal
.DF "0.6681523e-02 -0.6736254e-01 0.2584541e+00 -0.3676691e+00 -0.4461204e+00 0.2740512e+01 -0.5236615e+01 0.6184454e+01 -0.3072334e+01"
.NE
\fIX\fR (FloatState): internal
.DF "0"
.ET
.LD
.PP
This star computes the logarithm (default base = e)
of its input by first computing ln(x).
Floating-point evaluation of ln(x) can be performed by representing x
as s*(2^e) where s is the significand and e is the unbiased exponent.
Then ln(x) = 0.6931471 * log2(x),
where log2(x) = log2(s) + e.
For the significand s,
log2(s) can be evaluated with a polynomial.
By adding the unbiased exponent,
log2(x) results.
.PP
To get logarithm with base other than e,
set the \fIbase\fR parameter to the desired base.
.UH BUGS
Since log2(x) is evaluated anyway,
there should be an option where the user
can request log2(x) without having to set
the base.
.ES
