.\" documentation file generated from CG96LevDur.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LevDur"
.SD
Levinson-Durbin algorithm.
.SE
.LO "CG96 dsp library"
.DM CG96 CG96Star
.SV 1.9 "12/8/92"
.AL "Chih-Tsung Huang"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIautocor\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.NE
\fIerrPower\fR (float)
.PE
.SH
.NE
\fIorder\fR (IntState): provides orderth prediction error power on the output power.
.DF "16"
.NE
\fImode\fR (IntState): Mode 1 - autocorrelation -> reflection coef
                      Mode 2 - autocorrelation -> AR coef
.DF "1"
.NE
\fIarCoef\fR (FloatArrayState): internal
.DF "0"
.ET
.LD
.PP
This star uses as inputs the autocorrelation series
calculated with the CG96CrossCorr star
and uses the Levinson-Durbin algorithm
to compute either the reflection ceofficients
or the FIR linear predictor coefficients.
If the \fIunbiased\fR paramter of the CG96CrossCorr star is set to "No",
then the combined effect of that star and this one
is called the autocorrelation algorithm.
The parameter \fIorder\fR should be set equal to
the parameter \fInoLags\fR in the CG96CrossCorr star.
The star expects inputs of the order:
r(0), r(1), ... , r(order).
The output \fBoutput\fR depends on the parameter \fImode\fR:
.IP
If \fImode\fR is set to 1,
the \fBoutput\fR output produces the reflection coefficients
k(1), k(2), ... , k(order).
This set of coefficients is sutibale for directly
feeding the CG96BlockLattice star
which accepts outside coefficients
and produces the forward and backward prediction error.
.IP
If \fImode\fR is set to 2,
the \fBoutput\fR output produces the FIR linear predictor coefficients
a(1), a(2), ... , a(order).
This set of coefficients is sutibale for directly
feeding the CG96BlockFir star
which accepts outside coefficients
and produces the forward prediction of the process.
.PP
In addition to the output \fBoutput\fR,
the star also produces the \fIorder\fRth prediction error power
on the output \fBerrPower\fR.
.PP
Note that the definition of reflection coefficients
is not quite universal in the literature.
The reflection coefficients generated by this star
are the negative of the ones corresponding to
the definition of partial-correlation (PARCOR)
coefficients in the statistics literature.
.UH REFERENCES
.IP [1]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.IP [2]
S. Haykin, \fIModern Filters\fR, MacMillan Publishing Company,
New York, 1989.
.ES
