.\" documentation file generated from CG96LMS.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LMS"
.SD
Least mean square (LMS) adaptive filter.
.SE
.LO "CG96 dsp library"
.DM CG96 CG96Star
.SV 1.9 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIinput\fR (float)
.NE
\fIerror\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fIstepSize\fR (FloatState): specifies the rate of adaptation
.DF "0.01"
.NE
\fIerrorDelay\fR (IntState): specifies the relative delay between the output samples and the input
error samples.
.DF "1"
.NE
\fIdecimation\fR (IntState): number of input samples consumed before firing.
.DF "1"
.NE
\fIdecimationPhase\fR (IntState): phase change
.DF "0"
.NE
\fIcoef\fR (FloatArrayState): internal
.DF "0.1 0.2 0.3 0.4"
.NE
\fIcoefLen\fR (IntState): number of coef.
.DF "4"
.NE
\fIY\fR (IntState): internal
.DF "0"
.NE
\fIloopVal\fR (IntState): internal
.DF "0"
.NE
\fIdelayLine\fR (IntArrayState): internal
.DF "0"
.NE
\fIdelayLineStart\fR (IntState): internal
.DF "0"
.NE
\fIdelayLineSize\fR (IntState): internal
.DF "0"
.ET
.LD
.PP
This star implements an adaptive FIR filter using the LMS algorithm,
according to the following equations:
.EQ
delim $$
.EN
.nf
                                          $y~=~c~*~x$
                                          $e~=~(~{y hat}~-~y~)$
                                $c[n+1]~=~c[n]~+~stepSize~cdot~x~cdot~e$
.fi
.PP
where "x" is the input vector; "c", the coefficient vector;
"e", the input error; "y", the output; and
"$y hat$", the desired output.
Note that the error equation assumes a positive \fIstepSize\fR, and that
the error must be calculated outside of this star.
Be careful with the sign of the error!
.PP
Note that the number of initial coefficients determines "N",
the order of the filter.
.PP
The \fIstepSize\fR parameter specifies the rate of adaptation.
.PP
The \fIerrorDelay\fR specifies the relative delay between the output
samples and the input error samples.  There must be at least
a delay of one (you must add the delay in your system) because
the path from the output to the error forms a closed feedback loop.
You can insert more delays if you wish (you may have to decrease
the stepSize to keep the algorithm stable), but be sure to
adjust the \fIerrorDelay\fR parameter accordingly.
.PP
The \fIdecimation\fR parameter specifies how many input samples to
consume before firing the star.
Note that this downsampling could also be performed by following the
\fICG96LMS\fR star with a \fICG96Downsample\fR star.
However, the \fICG96LMS\fR star would then calculate samples, only to have
many of them immediately discarded by the \fICG96Downsample\fR star.
Using the \fIdecimation\fR ability in the complex LMS filter is
exactly equivalent, except that the discarded samples are never computed.
.PP
For decimation, the sample that is taken is controlled
by the parameter \fIdecimationPhase\fR.
If \fIdecimationPhase\fR = 0, the most recent sample is the output;
while if \fIdecimationPhase\fR = \fIdecimation\fR-1,
the oldest sample is the output.
.PP
Interpolation is not supported.
.PP
.SA
Downsample and
FIR.
.ES
