.\" documentation file generated from CG96IIR.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "IIR"
.SD
A simple general IIR filter
.SE
.LO "CG96 dsp library"
.DM CG96 CG96Star
.SV 1.9 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIsignalIn\fR (float)
.PE
.OH
.NE
\fIsignalOut\fR (float)
.PE
.SH
.NE
\fInumerator\fR (FloatArrayState): Filter FIR tap values.
.DF "0.25 0.5 0.75 1"
.NE
\fIdenominator\fR (FloatArrayState): Filter IIR tap values.
.DF "0.75 0.5 0.25"
.NE
\fIoldsample\fR (FloatArrayState): internal
.DF "0"
.NE
\fIoldsampleStart\fR (IntState): pointer to oldsample
.DF "0"
.NE
\fIoldsampleSize\fR (IntState): size of oldsample
.DF "0"
.NE
\fItapsNumerator\fR (IntState): internal
.DF "4"
.NE
\fItapsDenominator\fR (IntState): internal
.DF "4"
.NE
\fIminOrder\fR (IntState): internal
.DF "0"
.NE
\fImaxOrder\fR (IntState): internal
.DF "0"
.ET
.LD
.PP
The star implements an infinite impulse response (IIR) filter.
.PP
The IIR filter can be thought of as a cascade of
an all-pole IIR filter and an all-zero FIR filter,
so \fBdenominator\fR refer to the coefficients for the all-pole filter
and \fBnumerator\fR refer to the coefficients for the all-zero filter.
.PP
To read coefficients from a file, replace the default coefficients
with "<fileName". 
.PP
When designing the coefficients,
it is important to make sure that the denominator polynomial is monic,
i.e. the first coefficient is 1.
Then the \fIdenominator\fR 
contains the coefficients of the inverse-power terms of z.
Therefore, the first number of the taps is c(1).
.SA
FIR.
.ES
