.\" documentation file generated from CG96FIR.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "FIR"
.SD
A Finite Impulse Response (FIR) filter.
.SE
.LO "CG96 dsp library"
.DM CG96 CG96Star
.SV 1.12 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIsignalIn\fR (float)
.PE
.OH
.NE
\fIsignalOut\fR (float)
.PE
.SH
.NE
\fItaps\fR (FloatArrayState): Filter tap values.
.DF "-.040609 -.001628 .17853 .37665 .37665 .17853 -.001628 -.040609"
.NE
\fIdecimation\fR (IntState): Decimation ratio.
.DF "1"
.NE
\fIdecimationPhase\fR (IntState): Decimation phase.
.DF "0"
.NE
\fIinterpolation\fR (IntState): Interpolation ratio.
.DF "1"
.NE
\fIoldsample\fR (FloatArrayState): internal
.DF "0"
.NE
\fIoldsampleStart\fR (IntState): pointer to oldsample
.DF "0"
.NE
\fIoldsampleSize\fR (IntState): size of oldsample
.DF "0"
.NE
\fItapsNum\fR (IntState): internal
.DF "8"
.NE
\fIeftaps\fR (IntState): internal
.DF "0"
.NE
\fIindex\fR (IntState): internal
.DF "0"
.NE
\fIadjust\fR (IntState): internal
.DF "0"
.NE
\fIflag\fR (IntState): internal
.DF "0"
.ET
.LD
.PP
The star implements a finite impulse response filter
with multirate capability.
.PP
Coefficients are in the "taps" state variable.
Default coefficients give an 8th order, linear phase lowpass filter.
To read coefficients from a file, replace the default coefficients
with "<fileName".
.PP
The parameters \fIdecimation\fR and \fIinterpolation\fR enable this star
to perform downsampling or upsampling.
Only one of these 2 parameters can be set to greater than 1.
.PP
For decimation, the sample that is taken is controlled
by the parameter \fIdecimationPhase\fR.
If \fIdecimationPhase\fR = 0, the most recent sample is the signalOut;
while if \fIdecimationPhase\fR = \fIdecimation\fR-1,
the oldest sample is the signalOut.
.SA
IIR.
.ES
