.\" documentation file generated from CG96Cut.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Cut"
.SD
On each execution, this star reads a block of "nread" samples (default 128)
and writes "nwrite" of these samples (default 64), skipping the first
"offset" samples (default 0).  It is an error if nwrite + offset > nread.
If nwrite > nread, then the output consists of overlapping windows,
and hence "offset" must be negative.
.SE
.LO "CG96 control library"
.DM CG96 CG96Star
.SV 1.7 "12/8/92"
.AL "Chih-Tsung Huang"
.IH
.NE
\fIinput\fR (ANYTYPE)
.PE
.OH
.NE
\fIoutput\fR (ANYTYPE)
.PE
.SH
.NE
\fInread\fR (IntState): Number of particles read.
.DF "128"
.NE
\fInwrite\fR (IntState): Number of particles written.
.DF "64"
.NE
\fIoffset\fR (IntState): Position of output block relative to input block.
.DF "0"
.ET
.LD
This star reads a block of particles of any type, and writes a block
of particles that somehow overlaps the input block.
The number of input particles consumed is given by \fInread\fR,
and the number of output particles produced is given by \fInwrite\fR.
The \fIoffset\fR parameter (default 0) specifies where the output
block should start, relative to the beginning of the input block.
To avoid trying to read samples that have not yet been consumed,
it is required that $nwrite ~+~ offset ~<=~ nread$.
Hence, if $nwrite ~>~ nread$, \fIoffset\fR must be negative,
and the output consists of overlapping blocks input particles.
.ES
