.\" documentation file generated from CG96Crosscor.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Crosscor"
.SD
Estimates an crosscorrelation by averaging input samples.
.SE
.LO "CG96 dsp library"
.DM CG96 CG96Star
.SV 1.7 "12/8/92"
.AL "Chih-Tsung Huang, ported from gabriel"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIxin\fR (float)
.NE
\fIyin\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fInoInputsToAvg\fR (IntState): Number of input samples to average.
.DF "64"
.NE
\fInoLags\fR (IntState): Number of autocorrelation lags to output.
.DF "16"
.NE
\fIunbiased\fR (IntState): If YES, the estimate will be unbiased.
.DF "YES"
.NE
\fIsymmetric\fR (IntState): If YES, output is symmetric about n.
.DF "YES"
.NE
\fIcopy\fR (FloatArrayState): internal
.DF "0"
.NE
\fIoldoutput\fR (FloatArrayState): internal
.DF "0"
.NE
\fIfactors\fR (FloatArrayState): internal
.DF "0"
.NE
\fIX\fR (FloatState): internal
.DF "0"
.ET
.LD
.PP
This star estimates a certain number of samples
of the cross correlation of the 2 inputs
by averaging a certain number of input samples.
The number of outputs depend on the values of the parameters.
.IP
If \fInoLags\fR=0, then the star produces only 1 output,
which corresponds to the power of the process.
.IP
If \fInoLags\fR!=0 and \fIsymmetric\fR is set to "Yes",
then the star produces (2*\fInoLags\fR) outputs.
The output is symmetric about n=0
and can be used for power spectrum calculations.
.IP
If \fInoLags\fR!=0 and \fIsymmetric\fR is set to "No",
then the star produces (1+\fInoLags\fR) outputs.
The output can be used as input for the Levinson-Durbin star.
.PP
This block can also estimate the autocorrelation
of a sequence by connecting the 2 inputs to the same source.
.PP
If the parameter \fIunbiased\fR is set to "No",
then the correlation is given by:
.br
.nf
        r(k) = 1/(N) * Sum(n=k...N-1)[x(n) * y(n-k)]
.fi
for k=0,...,p;
where N is the number of input to average (\fInoInputsToAvg\fR)
and p is the number of lags to estimate (\fInoLags\fR).
This estimate is biased because the outermost lags
have fewer than N terms in the summation,
and yet the summation is still normalized by N.
.PP
If the parameter \fIunbiased\fR is set to "Yes" (the default),
then the correlation is given by:
.br
.nf
        r(k) = 1/(N-k) * Sum(n=k...N-1)[x(n) * y(n-k)]
.fi
for k=0,...,p;
where N is the number of input to average (\fInoInputsToAvg\fR)
and p is the number of lags to estimate (\fInoLags\fR).
In this case, the estimate is unbiased.
However, note that if the block is used for
autocorrelation estimation, the unbiased estimate does not
guarantee a positive definite sequence,
so a power spectral estimate based on this estimate
may have negative components.
.SA
CG96Average.
.ES
