.\" documentation file generated from CG96Burg.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Burg"
.SD
Burg's algorithm for estimation of reflection ceofficients
.SE
.LO "CG96 dsp library"
.DM CG96 CG96Star
.SV 1.7 "12/8/92"
.AL "Chih-Tsung Huang, ported from gabriel"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fInumInputs\fR (IntState): The number of inputs used to estimate the model.
.DF "64"
.NE
\fIorder\fR (IntState): The number of reflection coefficients to generate.
.DF "16"
.NE
\fIfp\fR (FloatArrayState): internal
.DF "0"
.NE
\fIbp\fR (FloatArrayState): internal
.DF "0"
.ET
.LD
.PP
This star uses Burg's algorithm to estimate
the reflection coefficients of an input random process.
The number of inputs looked at is given by
the \fInumInputs\fR parameter and the order of the AR model
is given by the \fIorder\fR parameter.
The order specifies how many outputs appear on the output.
.PP
Note that the definition of reflection coefficients
is not quite universal in the literature.
The reflection coefficients generated by this star
are the negative of the ones corresponding to
the definition of partial-correlation (PARCOR)
coefficients in the statistics literature.
.UH REFERENCES
.IP [1]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.IP [2]
S. Haykin, \fIModern Filters\fR, MacMillan Publishing Company,
New York, 1989.
.ES
