.\" documentation file generated from CG96BlockFIR.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "BlockFIR"
.SD
An FIR filter with coefficients externally supplied.
.SE
.LO "CG96 dsp library"
.DM CG96 CG96Star
.SV 1.8 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.AC "Gabriel version by Anthony Wong"
.IH
.NE
\fIsignalIn\fR (float)
.NE
\fIcoefs\fR (float)
.PE
.OH
.NE
\fIsignalOut\fR (float)
.PE
.SH
.NE
\fIblockSize\fR (IntState): Number of inputs that use each each coefficient set.
.DF "128"
.NE
\fIorder\fR (IntState): Number of new coefficients to read each time.
.DF "8"
.NE
\fIdecimation\fR (IntState): Decimation ratio.
.DF "1"
.NE
\fIdecimationPhase\fR (IntState): Downsampler phase.
.DF "0"
.NE
\fIinterpolation\fR (IntState): Interpolation ratio.
.DF "1"
.NE
\fIconstant\fR (FloatArrayState): internal
.DF "0"
.NE
\fIoldsample\fR (FloatArrayState): internal
.DF "0"
.NE
\fIoldsampleStart\fR (IntState): internal
.DF "0"
.NE
\fIindex\fR (IntState): internal
.DF "0"
.NE
\fImodtemp\fR (IntState): internal
.DF "0"
.ET
.LD
.PP
This star implements an FIR filter with coefficients
that are periodically updated from the outside.
The \fIblockSize\fR parameter tells how often the updates occur.
It is an interger specifying how many input samples
should be processed using each set of coefficients.
The \fIorder\fR parameter tells how many coefficients there are.
.PP
The parameters \fIdecimation\fR and \fIinterpolation\fR enable this star
to perform downsampling or upsampling.
Only one of these 2 parameters can be set to greater than 1.
.PP
For decimation, the sample that is taken is controlled
by the parameter \fIdecimationPhase\fR.
If \fIdecimationPhase\fR = 0, the most recent sample is the output;
while if \fIdecimationPhase\fR = \fIdecimation\fR-1,
the oldest sample is the output.
.SA
FIR.
.ES
