.\" documentation file generated from CG56Sin.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Sin"
.SD
Sine function.
Calculation by table lookup.  Input range of (-1,1) scaled by pi.
Output is sin(pi*input).
.SE
.LO "CG56 nonlinear functions library"
.DM CG56 CG56Star
.SV 1.11 "1/19/93"
.AL "Kennard, Chih-Tsung Huang (ported from Gabriel)"
.AC "Gabriel version by Maureen O'Reilly"
.IH
.NE
\fIinput\fR (FIX)
.PE
.OH
.NE
\fIoutput\fR (FIX)
.PE
.SH
.NE
\fIphase\fR (FloatState): "Additive phase relative to the sin() function."
.DF "0"
.NE
\fIphaseOffset\fR (IntState): "Munged form of phase."
.DF "0"
.ET
.LD
This star computes the sine of the input, which must be in the range
(-1.0, 1.0).
The output equals sin($~pi~cdot~$\fIin\fR$+\fIphase\fR$),
so the input range is effectively (-$~pi$, $pi~$).
The output is in the range (-1.0, 1.0).
The parameter \fIphase\fR is in degrees (e.g., cos() would use phase=90).
.ES
