.\" documentation file generated from CG56SSI.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "SSI"
.SD
A generic input/output star the DSP56001 SSI port.
.SE
.LO "CG56 io library"
.DM CG56 CG56Star
.SV 1.11 "12/3/92"
.AL "Kennard White, Chih-Tsung Huang (ported from Gabriel)"
.AC "Gabriel version by Jeff Bier, Phil Lapsley, Eric Guntvedt."
.IH
.NE
\fIinput1\fR (FIX)
.NE
\fIinput2\fR (FIX)
.PE
.OH
.NE
\fIoutput1\fR (FIX)
.NE
\fIoutput2\fR (FIX)
.PE
.SH
.NE
\fIhardware\fR (StringState): Name of physical hardware attached to SSI.
.DF "PROPORT"
.NE
\fIsymmetricBuffers\fR (IntState): If TRUE use symmetric queuing, else use dual buffering.
.DF "YES"
.NE
\fIqueueSize\fR (IntState): Length of interupt queue (0==>polling).
.DF "4"
.NE
\fIabortOnRealTimeError\fR (IntState): If TRUE, abort on real time violation.
.DF "YES"
.NE
\fIcra\fR (IntState): Port C SSI control register A (custom hardware only).
.DF "0"
.NE
\fIcrb\fR (IntState): Port C SSI control register B (custom hardware only).
.DF "0"
.NE
\fIbufLen\fR (IntState): internal
.DF "4"
.NE
\fIintrAbort\fR (IntState): Integer form of abortOnRealTimeError (for macros).
.DF "1"
.NE
\fIdualbufFlag\fR (IntState): state version of !doSymmetric
.DF "0"
.NE
\fImissCnt\fR (IntState): Count of missed interupt samples.
.DF "0"
.NE
\fIbuffer\fR (FixArrayState): internal
.DF "0"
.NE
\fIrecvStarPtr\fR (IntState): internal
.DF "0"
.NE
\fIxmitStarPtr\fR (IntState): internal
.DF "0"
.NE
\fIrecvIntrPtr\fR (IntState): internal
.DF "0"
.NE
\fIxmitIntrPtr\fR (IntState): internal
.DF "0"
.NE
\fIsaveReg\fR (FixArrayState): internal
.DF "0"
.NE
\fIsavePrevOut\fR (IntState): Boolean flag indicating to save previous output values.
.DF "0"
.NE
\fIprevOut1\fR (FixState): Copy of previous output#1 sample.
.DF "0"
.NE
\fIprevOut2\fR (FixState): Copy of previous output#2 sample.
.DF "0"
.ET
.LD
.PP
This star is a generic star to provide input/ouput for the 560001's
SSI (Synchronous Serial Interface) port.
.Ir "SSI port (Motorola DSP56001)"
.Ir "synchronous serial interface (Motorola DSP56001)"
.Ir "serial interface, synchronous (Motorola DSP56001)"
.Ir "DSP56001 SSI port"
.Ir "Motorola DSP56001 SSI port"
.Ir "real-time I/O"
.Ir "I/O, real-time"
It can implement both a
synchronous, in-line interface based on polling,
and an interupt-driven interface.
.Ir "interrupt-driven I/O"
.Ir "polling I/O"
The star inputs one sample from each of the two input channels
and outputs one sample to each of the two output channels each
time it fires.  The samples from the star's two input ports
are transmited out the SSI port,
and samples received from the SSI port are available on the star's
two outputs.
The star could be modified to support different
sample rates on input and output.
.PP
This star is commonly used as a base class for the Ariel Proport A/D and D/A
.Ir "Ariel Proport"
.Ir "Proport, Ariel"
converter and the modified Magnavox CD player.
.Ir "Magnavox CD player"
.Ir "CD player, Magnavox"
.PP
If the star is repeated in a schedule (for example, if it is
connected to a star that consumes more than one sample each time
it fires), interrupt-based code will be generated.
If the star is not repeated, it will generate code
that polls the SSI and busy waits if samples are not available.
Interrupt-based code can be forced by setting the buffer size non-zero.
The interrupt buffer holds at least \fIqueueSize\fP samples; the length
of the queue will be adjusted upward according to the number of schedule
repetitions of the star.  If \fIqueueSize\fP is negative, the negative
of \fIqueueSize\fP is used directly without adjusting it for the
number of star repetitions.  If stereo activity is occuring,
the queue length will be doubled.
.PP
.Ir "real-time violation"
If a real-time violation occurs and the parameter
\fIabortOnRealtimeError\fP is TRUE, execution will abort
and one of the following error codes will be left in register y0:
.ip "\fB123062\fP"
An interrupt occurred and the receive buffer was full.
.ip "\fB123063\fP"
An interrupt occurred and the transmit buffer was empty.
.UH "INTERUPTS: QUEUES:"
.pp
When using interupt based code, the SSI port generates interupts
that are handled by an interrupt service routine (ISR).
.Id "interrupt buffers"
.Id "buffers, interrupt"
.Id "queues, interrupt"
The ISR transmits samples
out of a xmit queue, and stores received samples in a recv queue.
The syncronous star code transfers data between these queues
and the star portholes.  The data words in each buffer are called
"slots", and at any given moment in time, a slot is either full (has
a valid sample) or is empty.  
If a slot has valid data in it, bit #0 is cleared, otherwise it is set.
There are two approaches to managing the
memory and syncronization of these queues; these are described below.
.UH "INTERUPTS: DUAL-BUFFER QUEUEING:"
.pp
Two buffers are maintained:
.Id "dual-buffer queuing"
.Id "queuing, dual-buffer"
a recv buffer and an xmit buffer.
The interrupt handler reads from the SSI port, placing
the word in the recv buffer and clears the bit; it then takes a word
from the xmit buffer, sets bit #0 in the slot, and writes it to the SSI.
.PP
The only reason to use dual-buffering is to support different recv and xmit
rates.  In this case two independent buffers are required with
independent pointers for each stream.  Note also
that the SDF parameters of the star must correspond to the relative
recv and xmit rates, or buffer overflow/underrun will occur.
.PP
This star was originally written to use dual buffers, but has never
(and still doesn't) support differing recv and xmit rates.  The code
preserves this style for future use, but in general it should not be used,
because it is less efficient than symmetric queuing, described below.
.UH "SYMMETRIC QUEUEING:"
.pp
.Id "symmetric queuing"
.Id "queuing, symmetric"
Symetric buffer queueing may be used only when the recv and xmit samples rates
are the same.  In this case, we can always access the recv and xmit samples
in pairs.  We align the two buffers symmetrically in X and Y memory.
This has the advantage that a single pointer can be used to walk through
the queues instead of two paraell pointers.  Semaphoring of slots
filled/empty status is easier: only one slot of the (recv/xmit)
pair need be marked.  If bit #0 is set in the recv sample, the slot
is empty and next slot is full.
.PP
To implement synchronized recv and xmit on the 56001, we used symmetric memory,
taking advantage of the fact that we have independent X: and Y: memory.
This is not an intrinsic requirement: instead, we could have interleaved
the recv and xmit buffers together with an xmit slot following each recv slot.
The only difficulty would be holding off semaphoring the recv slot in
the star code: this would require using an extra register to preserve
the address until after the xmit had been taken care of.
.UH BUGS:
.pp
The bulk of the this star should really be implemented as a
real-time, memory mapped I/O port star,
with this star just providing the specific information about the SSI port.
This would be particularly useful when doing data acquisition via the Xylinx.
.PP
This star should be improved to support disabling (or hiding) or the
various ports (in order to make input-only, output-only, or mono stars).
.SA
ProPortAD,
ProPortDA,
MagnavoxIn and
MagnavoxOut.
.ES
