.\" documentation file generated from CG56ProPortADDA.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "ProPortADDA"
.SD
An input/output star for the Ariel ProPort
.SE
.LO "CG56 io library"
.DM CG56 CG56Star
.SV 1.7 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.AC "Gabriel version by Phil Lapsley"
.IH
.NE
\fIinput1\fR (FIX)
.NE
\fIinput2\fR (FIX)
.PE
.OH
.NE
\fIoutput1\fR (FIX)
.NE
\fIoutput2\fR (FIX)
.PE
.SH
.NE
\fIforceInterrupts\fR (StringState): If YES use interrupts, otherwise use polling.
.DF "No"
.NE
\fIinterruptBufferSize\fR (IntState): size of interrupt buffer, presently does not support repetition.
.DF "4"
.NE
\fIabortOnRealTimeError\fR (StringState): if yes, abort on rreal time error
.DF "yes"
.NE
\fIbufLen\fR (IntState): internal
.DF "4"
.NE
\fIstarInBufPtr\fR (FixState): internal
.DF "0"
.NE
\fIstarOutBufPtr\fR (FixState): internal
.DF "0"
.NE
\fIsaveReg\fR (FixArrayState): internal
.DF "0"
.NE
\fIinIntBuffer\fR (IntArrayState): internal
.DF "0"
.NE
\fIinIntBufferStart\fR (IntState): internal
.DF "0"
.NE
\fIoutIntBuffer\fR (IntArrayState): internal
.DF "0"
.NE
\fIoutIntBufferStart\fR (IntState): internal
.DF "0"
.ET
.LD
.PP
This star is an interrupt driven A/D and D/A star
for the Ariel Proport board.
The star inputs one sample from each of the two input channels
and outputs one sample to each of the two output channels each
time it fires.
.PP
If the star is repeated in a schedule (for example, if it is
connected to a star that consumes more than one sample each time
it fires), interrupt-based code will be generated.
If the star is not repeated, it will generate code
that polls the Proport and busy waits if samples are not available.
Interrupt-based code can be forced by setting the string
parameter \fIforceInterrupts\fP to "yes".
The interrupt buffer will be the minimum required size if the
parameter \fIinterruptBufferSize\fP is "default=4".
If this parameter is a number, it will be used for the length
(in words) of the interrupt buffer.
.PP
In the event of a real-time violation, execution will abort
and one of the following error codes will be left in register y0:
.ip "\fB123062\fP"
An interrupt occurred and the input buffer was full.
.ip "\fB123063\fP"
An interrupt occurred and the output buffer was empty.
.SA
ProPortAD and
ProPortDA.
.ES
