.\" documentation file generated from CG56Pad.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Pad"
.SD
Fix pad
On each execution, reads a block of "nread" samples (default 128) and writes
a block of "nwrite" samples (default 256).  The first "offset" samples
(default 0) have value "fill" (default 0.0), the next "nread" outputs
samples have values taken from the inputs, and last "nwrite" -
"nread" - "offset" samples have value "fill" again.
.SE
.LO "CG56 control library"
.DM CG56 CG56Star
.SV 1.7 "12/8/92"
.AL "Chih-Tsung Huang"
.IH
.NE
\fIinput\fR (fix)
.PE
.OH
.NE
\fIoutput\fR (fix)
.PE
.SH
.NE
\fInread\fR (IntState): Number of particles read.
.DF "128"
.NE
\fInwrite\fR (IntState): Number of particles written.
.DF "256"
.NE
\fIoffset\fR (IntState): Number of leading fill particles in each output block.
.DF "0"
.NE
\fIfill\fR (FloatState): Value of fill particles.
.DF "0.0"
.ET
.LD
The star pads the input with fill values.
An input block of length \fInread\fR is read in.
The first \fIoffset\fR outputs will be zeros,
then the next \fInread\fR outputs will be the inputs
that are read in, and any remaining outputs will be zeros.
To ensure correct operation,
\fInread\fR + \fIoffset\fR must be smaller than \fInwrite\fR.
.SA
Cut.
.ES
