.\" documentation file generated from CG56Mux.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Mux"
.SD
Multiplexes any number of inputs onto one output stream.
.SE
.LO "CG56 control library"
.DM CG56 CG56Star
.SV 1.10 "12/10/92"
.AL "Kennard White"
.AC "SDF version by E. A. Lee"
.IH
.NE
\fIinput\fR (multiple), (ANYTYPE)
.NE
\fIcontrol\fR (INT)
.PE
.OH
.NE
\fIoutput\fR (ANYTYPE)
.PE
.SH
.NE
\fIblockSize\fR (IntState): Number of particles in a block.
.DF "1"
.NE
\fIuseCircular\fR (IntState): "Boolean: use circular addressing on inputs."
.DF "1"
.NE
\fIptrvec\fR (IntArrayState): "Array of pointers to inputs (x:) and lengths (y:)."
.DF ""
.NE
\fIcurinput\fR (IntState): "Current input within go() loop."
.DF "0"
.NE
\fIuseModuloB\fR (IntState): "True if any input is not scalor."
.DF "0"
.ET
.LD
.Id "multiplex"
\fIblockSize\fP particles are consumed on each input.
But only one of these blocks of particles is copied to the output.
The one copied is determined by the \fIcontrol\fP input.
Integers from 0 through N-1 are accepted at the \fIcontrol\fP input,
where N is the number of inputs.  If the control input is outside
this range, random data (possibly memory mapped devices) will be copied.
.UH IMPLEMENTATION:
.pp
There are potentially very many special cases that could be handled
for increased efficiency: looped vs non-looped, circular vs linear,
and scalars vs vectors (blockSize > 1), 
uniform inputs vs non-uniform inputs (port.bufSize()).
The current implementation handles only some of these cases.  Use this
star at your own risk.
.pp
At compile time the star constructs a table of pointers to each of the
input blocks.  The \fIcontrol\fP input is used to index this table,
yielding a pointer to the appropriate input block for the firing.  This
implementation assumes that all of its input ports reside in X memory.
.pp
Currently we advance each of the pointers in the table on every firing.
With some schedule the advancement is a nop; this case is handled.
In other schedules the adancement is periodic over all inputs; in this
case, we could pre-calculate a set of tables at compile time instead
of performing run-time advancement.  This is not currently handled.
.ES
