.\" documentation file generated from CG56Magnavox.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Magnavox"
.SD
A combined input/output star for the Magnavox CD player.
.SE
.LO "CG56 io library"
.DM CG56 CG56Star
.SV 1.17 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.AC "Gabriel version by Jeff Bier, Phil Lapsley"
.IH
.NE
\fIinput1\fR (FIX)
.NE
\fIinput2\fR (FIX)
.PE
.OH
.NE
\fIoutput1\fR (FIX)
.NE
\fIoutput2\fR (FIX)
.PE
.SH
.NE
\fIforceInterrupts\fR (StringState): If YES use interrupts, otherwise use polling.
.DF "No"
.NE
\fIinterruptBufferSize\fR (IntState): size of interrupt buffer, presently does not support repetition.
.DF "4"
.NE
\fIabortOnRealTimeError\fR (StringState): if yes, abort on rreal time error
.DF "yes"
.NE
\fIbufLen\fR (IntState): internal
.DF "4"
.NE
\fIstarInBufPtr\fR (FixState): internal
.DF "0"
.NE
\fIstarOutBufPtr\fR (FixState): internal
.DF "0"
.NE
\fIsaveReg\fR (FixArrayState): internal
.DF "0"
.NE
\fIinIntBuffer\fR (IntArrayState): internal
.DF "0"
.NE
\fIinIntBufferStart\fR (IntState): internal
.DF "0"
.NE
\fIoutIntBuffer\fR (IntArrayState): internal
.DF "0"
.NE
\fIoutIntBufferStart\fR (IntState): internal
.DF "0"
.ET
.LD
.PP
This star is a combined input/output interface to a modified
Magnavox CD player.
The two inputs to the star are sent to the Magnavox CD player for output
on the left and right channels, and the
left and right channel samples from the CD player are available
on the star's two outputs.
.PP
If the star is repeated in a schedule (for example, if it is
connected to a star that consumes more than one sample each time
it fires), interrupt-based code will be generated.
If the star is not repeated, it will generate code
that polls the Magnavox and busy waits if samples are not available.
Interrupt-based code can be forced by setting the string
parameter \fIforceInterrupts\fP to "yes".
The interrupt buffer will be the minimum required size if the
parameter \fIinterruptBufferSize\fP is "default=4".
If this parameter is a number, it will be used for the length
(in words) of the interrupt buffer.
.PP
If a real-time violation occurs and the parameter
\fIabortOnRealtimeError\fP is set to "yes", the star
will abort execution
with one of the following hexadecimal error codes in register y0:
.ip "\fB123052\fP"
An interrupt occurred and the receive buffer was full.
.ip "\fB123053\fP"
An interrupt occurred and the transmit buffer was empty.
.UH BUGS:
.pp
The \fIabortOnRealtimeError\fP parameter is ignored when
interrupt-based code is generated.
.SA
MagnavoxIn and
MagnavoxOut.
.ES
