.\" documentation file generated from CG56LMS.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "LMS"
.SD
Least mean square (LMS) adaptive filter.
.SE
.LO "CG56 dsp library"
.DM CG56 CG56Star
.SV 1.10 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.AC "Gabriel version by E. A. Lee, Maureen O'Reilly"
.IH
.NE
\fIinput\fR (fix)
.NE
\fIerror\fR (fix)
.PE
.OH
.NE
\fIoutput\fR (fix)
.PE
.SH
.NE
\fIstepSize\fR (FixState): specifies the rate of adaptation
.DF "0.01"
.NE
\fIerrorDelay\fR (IntState): specifies the relative delay between the output samples and the input
error samples.
.DF "1"
.NE
\fIdecimation\fR (IntState): number of input samples consumed before firing.
.DF "1"
.NE
\fIcoef\fR (FixArrayState): internal
.DF "-4.0609e-2 -1.6280e-3 1.7853e-1 3.7665e-1 3.7665e-1 1.7853e-1 -1.6280e-3 -4.0609e-2"
.NE
\fIcoefLen\fR (IntState): number of coef.
.DF "8"
.NE
\fIY\fR (IntState): internal
.DF "0"
.NE
\fIloopVal\fR (IntState): internal
.DF "0"
.NE
\fIdelayLine\fR (IntArrayState): internal
.DF "0"
.NE
\fIdelayLineStart\fR (IntState): internal
.DF "0"
.NE
\fIdelayLineSize\fR (IntState): internal
.DF "0"
.ET
.LD
.pp
This star implements an adaptive filter using the LMS algorithm.
The initial coefficients determine the order of the filter.
The default coefficients specify
an eighth order, equiripple, linear-phase, lowpass filter,
the same as the default coefficients of the \fIFIR\fP star.
.PP
The \fIstepSize\fP parameter specifies the rate of adaptation.
.PP
The \fIerrorDelay\fP parameter specifies the relative delay between the output
samples and the input error samples.  There must be at least
a delay of one (you must add the delay in your system) because
the path from the output to the error forms a closed feedback loop.
You can insert more delays if you wish (you may have to decrease
\fIstepSize\fP to keep the algorithm stable), but be sure to
adjust the \fIerrorDelay\fP parameter accordingly.
.PP
The \fIdecimation\fP parameter specifies how many input samples should be
consumed before firing the star.  For example, to downsample
by a factor of two, the user could simply follow the LMS filter by
a downsample star, which would be set to discard every second input.
But it is inefficient for the LMS filter to compute these samples,
only to have them discarded.  Setting the \fIdecimation\fP parameter to 2
in the LMS filter is exactly equivalent,
except that the discarded samples are not computed.
Interpolation is not supported.
.ES
