.\" documentation file generated from CG56Integrator.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Integrator"
.SD
An integrator with leakage and limits.  With the default parameters,
input samples are simply accumulated, and the running sum is the
output.  If there is an overflow, the integrator will wrap around.
.SE
.LO "CG56 nonlinear functions library"
.DM CG56 CG56Star
.SV 1.13 "12/8/92"
.AL "Kennard, J. Pino (ported from Gabriel)"
.IH
.NE
\fIinput\fR (FIX)
.PE
.OH
.NE
\fIoutput\fR (FIX)
.PE
.SH
.NE
\fIfeedbackGain\fR (FixState): The gain on the feedback path.
.DF "ONE"
.NE
\fIunityGainB\fR (IntState): "Boolean: is the feedbackGain unity?"
.DF "0"
.NE
\fIonOverflow\fR (StringState): On overflow, either wrap around, saturate or reset.
.DF "wrap around"
.NE
\fIinitialValue\fR (FixState): Value at time zero and also reset value if used.
.DF "0"
.NE
\fIsum\fR (FixState): An internal state.
.DF "0"
.ET
.LD
.Id "filter, integrator"
.pp
Leakage is controlled by the \fPfeedbackGain\fP state (default 1.0).
The output is the data input plus feedbackGain*state, where state is the
previous output.
.pp
Overflow is controlled by the \fIonOverflow\fP state (default wrap around.
The integrator can either be set to wrap around (default), saturate or
reset.
.ES
