.\" documentation file generated from CG56IIDGaussian.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "IIDGaussian"
.SD
Gaussian Noise Source
.SE
.LO "CG56 signal sources library"
.DM CG56 CG56Star
.SV 1.11 "12/8/92"
.AL "Chih-Tsung Huang, Kennard White (ported from Gabriel)"
.OH
.NE
\fIoutput\fR (fix)
.PE
.SH
.NE
\fInoUniforms\fR (IntState): uniform random variables.
.DF "16"
.NE
\fIaccum\fR (IntState): internal
.DF "0"
.NE
\fIravs\fR (FixArrayState): internal
.DF "0"
.ET
.LD
.PP
.Id "Gaussian noise"
.Id "noise, Gaussian"
This star generates a sequence of random output samples with a Gaussian
distribution (mean = 0, standard deviation = 0.1).
.PP
.Ir "central limit theorem"
According to the central limit theorem, the sum of N random variables
approaches a Gaussian distribution as N approaches infinity.
This star generates an output number by summing \fInoUniforms\fR uniform
random variables.
.PP
The parameters \fIseed\fR and \fImultiplier\fR control the generation of the
random number. 
.UH BUGS:
.LP
This needs to be filled in.  For now, there is no seed and multiplier
parameter; the default seed parameter from Gabriel is always used.
We'd really need to use a 48-bit integer to get the same functionality.
This can be done with g++ (type "long long"), but it isn't portable.
.LP
The Gabriel version used l:aa addressing for the accum address.
This failed when the accumulator is not :aa addressable (high memory), 
so it now moves the address into a register and uses l:(rn) addressing.
.LP
The loop that calculates the series of uniform variables should really
be pipelined better and should keep the accum value in register instead
of flushing and reloading to/from memory every iteration.
.LP
Incorrect code will probably be generated generated if the number of uniform
variables used is less than 2 or 3.
.ES
