.\" documentation file generated from CG56HostSlider.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "HostSlider"
.SD
Graphical host slider for asyncronous input source.
.SE
.LO "CG56 io library"
.DM CG56 CG56HostASrc
.SV 1.7 "12/8/92"
.AL "Kennard White"
.AC "Based on CG56HostSliderGX"
.SH
.NE
\fIhostMin\fR (FloatState): Host minimum value.
.DF "-1"
.NE
\fIhostMax\fR (FloatState): Host maximum value.
.DF "1"
.NE
\fIhostInitVal\fR (FloatState): Initial value.
.DF "0"
.NE
\fIdspMin\fR (FixState): DSP minimum value.
.DF "-1"
.NE
\fIdspMax\fR (FixState): DSP maximum value.
.DF "1"
.NE
\fIscale\fR (StringState): "type of scale(mapping)".
.DF "linear"
.ET
.LD
.Ir "slider bar"
.Ir "scale"
This is an asynchronous source star (like the Const star) with
a particular X windows graphical interface on the host.
It is indended that this star be used with a graphical target monitor
(.e.g., qdm_s56x).
.LP
The \fBslider\fP widget presents the user with a "ruler" along which
the user may slide a marker.  The value output cooresponds to the
current location of the slider.
The \fIdspMin\fP and \fIdspMax\fP states control the range of values
that will be output on the DSP.
The \fIhostMin\fP and \fIhostMax\fP states control the range of values
the user sees (the limits of the "ruler"),
and \fIhostInitVal\fP is the initial value in the host coordinate set.
The host values are \fBalways\fP linearly mapped onto the dsp values.
The \fIscale\fP parameter controls how host values are displayed to
the user (linear,logrithmic,db10,db20).  It is important to note that
this controls only the values displayed and not the mapping from host
values to dsp values.
.UH IMPLEMENTATION:
.pp
This is a Ptolemy replacement for Gabriel host slider system.
Unlike the Gabriel system, there is no need to specify a "command" to execute
to bring up the slider bars, since Ptolemy targets automatically arrange for
the asynchronous input/output to be handled using a qdm derivative.
Also, the host value may be floating point.
.ES
