.\" documentation file generated from CG56HostButton.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "HostButton"
.SD
Graphical two-valued input source.
.SE
.LO "CG56 io library"
.DM CG56 CG56HostASrc
.SV 1.7 "12/8/92"
.AL "Kennard White"
.SH
.NE
\fIbuttonType\fR (StringState): Type of button: pushbutton, checkbutton.
.DF "pushbutton"
.NE
\fIcanonicalWidget\fR (StringState): Canonical form of widget name.
.DF "xxx"
.NE
\fIoffVal\fR (StringState): "Value to output when button off/not pressed (either FIX or INT)."
.DF "0.0"
.NE
\fIonVal\fR (StringState): "Value to output when button on/pressed (either FIX or INT)."
.DF "1.0"
.NE
\fIinitiallyOn\fR (IntState): "Boolean: Initial state is on? (checkbutton only)"
.DF "0"
.NE
\fIinitValStr\fR (StringState): "String form of initial value."
.DF "0"
.ET
.LD
.Ir "button"
This is an asynchronous source star (like the Const star) with a particular
graphical user interface.  The star always outputs one of two values;
which value is output is controled by a button.  There are two types
of buttons: \fBpushbutton\fPs and \fBcheckbutton\fPs.
Both presents a single button to the user that
may be "pressed" with the mouse.  The buttons differ
in the semantics of the push.
When the \fBpushbutton\fP is pressed, the \fIonVal\fP state
is output, otherwise \fIoffVal\fP.
The \fBcheckbutton\fP widget is either on or off; pressing it toggles
between on and off.  When on, the \fIonVal\fP state is output,
otherwise \fIoffVal\fP is output.
.LP
The \fIoffVal\fP and \fIonVal\fP should be either FIX or INT type.  They
are not examined at compile-time: they are passed literally to qdm (via
the aio file) and to the asembler (via the initial value).  Note
that there is a big difference between "1" and "1.0".
.ES
