.\" documentation file generated from CG56FIR.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "FIR"
.SD
Finite Impulse Response (FIR) filter.
Coefficients are in the "taps" state variable.  Default coefficients
give an 8th order, linear phase lowpass filter.  To read coefficients
from a file, replace the default coefficients with "<fileName".
Decimation parameter > 1 reduces sample rate.  Interpolation parameter
> 1 increases sample rate.
.SE
.LO "CG56 dsp library"
.DM CG56 CG56Star
.SV 1.18 "12/8/92"
.AL "Chih-Tsung Huang, ported from Gabriel"
.IH
.NE
\fIinput\fR (FIX)
.PE
.OH
.NE
\fIoutput\fR (FIX)
.PE
.SH
.NE
\fItaps\fR (FixArrayState): Filter tap values.
.DF "-.040609 -.001628 .17853 .37665 .37665 .17853 -.001628 -.040609"
.NE
\fIdecimation\fR (IntState): Decimation ratio.
.DF "1"
.NE
\fIinterpolation\fR (IntState): Interpolation ratio.
.DF "1"
.NE
\fIoldsample\fR (FixArrayState): internal
.DF "0"
.NE
\fIoldsampleStart\fR (IntState): pointer to oldsample
.DF "0"
.NE
\fIoldsampleSize\fR (IntState): size of oldsample
.DF "0"
.NE
\fItapsNum\fR (IntState): internal
.DF "8"
.NE
\fItp\fR (IntState): internal
.DF "0"
.NE
\fIadjust\fR (IntState): internal
.DF "0"
.NE
\fIdec\fR (IntState): internal
.DF "0"
.ET
.LD
The output of the FIR filter is given by:
.EQ
        y(n) ~ = ~ sum from { i = 0 } to { N - 1 } { c[i] x[N-i] }
.EN
where N is the order of the filter given by the number of coefficients in
\fItaps\fP.
c[i], i = 0..N-1 are the tap coefficients; and x[T-i] is the input i samples
before the current input.
.PP
The parameters \fIdecimation\fR and \fIinterpolation\fR enable this star
to perform downsampling or upsampling.
.PP
The default filter is a linear-phase equiripple lowpass filter with its 3dB
cutoff frequency at about 1/3 of the Nyquist frequency.
.ES
