proc InitGIDProject {dir} {

      set materials  [.central.s info materials] 
      set conditions [.central.s info conditions ovpnt] 

      CreateWindow $dir $materials $conditions

}


proc CreateWindow {dir mat cond} {
    
    set w .gid.win_elmer

    InitWindow $w "ELMER.TCL" Elmer "" \
	    "" 1

    frame $w.top
    label $w.top.title_text -text " Problem type: Elmer "
   
    frame $w.information  -relief ridge -bd 2 
    label $w.information.path        -text " Problem Type path: $dir "
    label $w.information.materials   -text " Avalaible materials: $mat"
    label $w.information.conditions  -text " Avalaible conditions: $cond"

    frame $w.bottom
    button $w.bottom.start -text "CONTINUE" \
           -height 1 -width 14 -command "destroy $w"
 
    pack $w.top.title_text -pady 10
    pack $w.information.path $w.information.materials \
         $w.information.conditions -side top -anchor w
    
    pack $w.bottom.start  -side left -anchor center
    pack $w.top 
    pack $w.information -expand yes -fill both
    pack $w.bottom -side top -padx 6 -pady 10 -ipady 2
}

