/**
 * This file is part of the mingw-w64 runtime package.
 * No warranty is given; refer to the file DISCLAIMER within this package.
 */

#include <winapifamily.h>

#ifndef _WINUSER_
#define _WINUSER_

#include <_mingw_unicode.h>
#include <apisetcconv.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef WINVER
#define WINVER 0x0502
#endif

#include <_mingw.h>
#include <stdarg.h>
#include <guiddef.h>

#ifndef NOAPISET
#include <libloaderapi.h>
#endif

#ifndef NOUSER
#if WINAPI_FAMILY_PARTITION (WINAPI_PARTITION_DESKTOP)
  typedef HANDLE HDWP;
  typedef VOID MENUTEMPLATEA;
  typedef VOID MENUTEMPLATEW;
  typedef PVOID LPMENUTEMPLATEA;
  typedef PVOID LPMENUTEMPLATEW;

  __MINGW_TYPEDEF_AW(MENUTEMPLATE)
  __MINGW_TYPEDEF_AW(LPMENUTEMPLATE)

  typedef LRESULT (CALLBACK *WNDPROC)(HWND,UINT,WPARAM,LPARAM);
#endif

#ifdef STRICT
#if WINAPI_FAMILY_PARTITION (WINAPI_PARTITION_APP)
  typedef INT_PTR (CALLBACK *DLGPROC) (HWND, UINT, WPARAM, LPARAM);
#endif

#if WINAPI_FAMILY_PARTITION (WINAPI_PARTITION_DESKTOP)
  typedef VOID (CALLBACK *TIMERPROC) (HWND, UINT, UINT_PTR, DWORD);
  typedef WINBOOL (CALLBACK *GRAYSTRINGPROC) (HDC, LPARAM, int);
  typedef WINBOOL (CALLBACK *WNDENUMPROC) (HWND, LPARAM);
  typedef LRESULT (CALLBACK *HOOKPROC) (int code, WPARAM wParam, LPARAM lParam);
  typedef VOID (CALLBACK *SENDASYNCPROC) (HWND, UINT, ULONG_PTR, LRESULT);

  typedef WINBOOL (CALLBACK *PROPENUMPROCA) (HWND, LPCSTR, HANDLE);
  typedef WINBOOL (CALLBACK *PROPENUMPROCW) (HWND, LPCWSTR, HANDLE);

  typedef WINBOOL (CALLBACK *PROPENUMPROCEXA) (HWND, LPSTR, HANDLE, ULONG_PTR);
  typedef WINBOOL (CALLBACK *PROPENUMPROCEXW) (HWND, LPWSTR, HANDLE, ULONG_PTR);

  typedef int (CALLBACK *EDITWORDBREAKPROCA) (LPSTR lpch, int ichCurrent, int cch, int code);
  typedef int (CALLBACK *EDITWORDBREAKPROCW) (LPWSTR lpch, int ichCurrent, int cch, int code);

  typedef WINBOOL (CALLBACK *DRAWSTATEPROC) (HDC hdc, LPARAM lData, WPARAM wData, int cx, int cy);
#endif
#else
#if WINAPI_FAMILY_PARTITION (WINAPI_PARTITION_APP)
  typedef FARPROC DLGPROC;
#endif

#if WINAPI_FAMILY_PARTITION (WINAPI_PARTITION_DESKTOP)
  typedef FARPROC TIMERPROC;
  typedef FARPROC GRAYSTRINGPROC;
  typedef FARPROC WNDENUMPROC;
  typedef FARPROC HOOKPROC;
  typedef FARPROC SENDASYNCPROC;

  typedef FARPROC EDITWORDBREAKPROCA;
  typedef FARPROC EDITWORDBREAKPROCW;

  typedef FARPROC PROPENUMPROCA;
  typedef FARPROC PROPENUMPROCW;

  typedef FARPROC PROPENUMPROCEXA;
  typedef FARPROC PROPENUMPROCEXW;

  typedef FARPROC DRAWSTATEPROC;
#endif
#endif

#if WINAPI_FAMILY_PARTITION (WINAPI_PARTITION_DESKTOP)
  __MINGW_TYPEDEF_AW(PROPENUMPROC)
  __MINGW_TYPEDEF_AW(PROPENUMPROCEX)
  __MINGW_TYPEDEF_AW(EDITWORDBREAKPROC)

#ifdef STRICT
  typedef WINBOOL (CALLBACK *NAMEENUMPROCA) (LPSTR, LPARAM);
  typedef WINBOOL (CALLBACK *NAMEENUMPROCW) (LPWSTR, LPARAM);
  typedef NAMEENUMPROCA WINSTAENUMPROCA;
  typedef NAMEENUMPROCW WINSTAENUMPROCW;
  typedef NAMEENUMPROCA DESKTOPENUMPROCA;
  typedef NAMEENUMPROCW DESKTOPENUMPROCW;
#else
  typedef FARPROC NAMEENUMPROCA;
  typedef FARPROC NAMEENUMPROCW;
  typedef FARPROC WINSTAENUMPROCA;
  typedef FARPROC WINSTAENUMPROCW;
  typedef FARPROC DESKTOPENUMPROCA;
  typedef FARPROC DESKTOPENUMPROCW;
#endif

  __MINGW_TYPEDEF_AW(WINSTAENUMPROC)
  __MINGW_TYPEDEF_AW(DESKTOPENUMPROC)
#endif

#define IS_INTRESOURCE(_r) ((((ULONG_PTR)(_r)) >> 16)==0)
#define MAKEINTRESOURCEA(i) ((LPSTR)((ULONG_PTR)((WORD)(i))))
#define MAKEINTRESOURCEW(i) ((LPWSTR)((ULONG_PTR)((WORD)(i))))
#define MAKEINTRESOURCE __MINGW_NAME_AW(MAKEINTRESOURCE)

#ifndef NORESOURCE
#define RT_CURSOR MAKEINTRESOURCE(1)
#define RT_BITMAP MAKEINTRESOURCE(2)
#define RT_ICON MAKEINTRESOURCE(3)
#define RT_MENU MAKEINTRESOURCE(4)
#define RT_DIALOG MAKEINTRESOURCE(5)
#define RT_STRING MAKEINTRESOURCE(6)
#define RT_FONTDIR MAKEINTRESOURCE(7)
#define RT_FONT MAKEINTRESOURCE(8)
#define RT_ACCELERATOR MAKEINTRESOURCE(9)
#define RT_RCDATA MAKEINTRESOURCE(10)
#define RT_MESSAGETABLE MAKEINTRESOURCE(11)

#define DIFFERENCE 11
#define RT_GROUP_CURSOR MAKEINTRESOURCE ((ULONG_PTR) (RT_CURSOR) + DIFFERENCE)
#define RT_GROUP_