/*
 * Copyright (C) 2007 Francois Gouget
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_WINHTTP_H
#define __WINE_WINHTTP_H

#ifdef _WIN64
#include <pshpack8.h>
#else
#include <pshpack4.h>
#endif

#define WINHTTPAPI
#define BOOLAPI WINHTTPAPI WINBOOL WINAPI


typedef LPVOID HINTERNET;
typedef HINTERNET *LPHINTERNET;

#define INTERNET_DEFAULT_PORT           0
#define INTERNET_DEFAULT_HTTP_PORT      80
#define INTERNET_DEFAULT_HTTPS_PORT     443
typedef WORD INTERNET_PORT;
typedef INTERNET_PORT *LPINTERNET_PORT;

/* Yes, these values contradict wininet.h */
#define INTERNET_SCHEME_HTTP            1
#define INTERNET_SCHEME_HTTPS           2
#define INTERNET_SCHEME_FTP             3
#define INTERNET_SCHEME_SOCKS           4
typedef int INTERNET_SCHEME, *LPINTERNET_SCHEME;

#define ICU_ESCAPE  0x80000000
#define ICU_ESCAPE_AUTHORITY 0x00002000
#define ICU_REJECT_USERPWD   0x00004000

/* flags for WinHttpOpen */
#define WINHTTP_FLAG_ASYNC                  0x10000000

/* flags for WinHttpOpenRequest */
#define WINHTTP_FLAG_ESCAPE_PERCENT         0x00000004
#define WINHTTP_FLAG_NULL_CODEPAGE          0x00000008
#define WINHTTP_FLAG_ESCAPE_DISABLE         0x00000040
#define WINHTTP_FLAG_ESCAPE_DISABLE_QUERY   0x00000080
#define WINHTTP_FLAG_BYPASS_PROXY_CACHE     0x00000100
#define WINHTTP_FLAG_REFRESH                WINHTTP_FLAG_BYPASS_PROXY_CACHE
#define WINHTTP_FLAG_SECURE                 0x00800000

#define WINHTTP_ACCESS_TYPE_DEFAULT_PROXY   0
#define WINHTTP_ACCESS_TYPE_NO_PROXY        1
#define WINHTTP_ACCESS_TYPE_NAMED_PROXY     3
#define WINHTTP_ACCESS_TYPE_AUTOMATIC_PROXY 4

#define WINHTTP_NO_PROXY_NAME               NULL
#define WINHTTP_NO_PROXY_BYPASS             NULL

#define WINHTTP_NO_CLIENT_CERT_CONTEXT      NULL

#define WINHTTP_NO_REFERER                  NULL
#define WINHTTP_DEFAULT_ACCEPT_TYPES        NULL

#define WINHTTP_NO_ADDITIONAL_HEADERS       NULL
#define WINHTTP_NO_REQUEST_DATA             NULL

#define WINHTTP_HEADER_NAME_BY_INDEX        NULL
#define WINHTTP_NO_OUTPUT_BUFFER            NULL
#define WINHTTP_NO_HEADER_INDEX             NULL

#define WINHTTP_ADDREQ_INDEX_MASK                    0x0000FFFF
#define WINHTTP_ADDREQ_FLAGS_MASK                    0xFFFF0000
#define WINHTTP_ADDREQ_FLAG_ADD_IF_NEW               0x10000000
#define WINHTTP_ADDREQ_FLAG_ADD                      0x20000000
#define WINHTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA      0x40000000
#define WINHTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON  0x01000000
#define WINHTTP_ADDREQ_FLAG_COALESCE                 WINHTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA
#define WINHTTP_ADDREQ_FLAG_REPLACE                  0x80000000

#define WINHTTP_IGNORE_REQUEST_TOTAL_LENGTH 0

/* flags for WinHttp{Set/Query}Options */
#define WINHTTP_FIRST_OPTION                         WINHTTP_OPTION_CALLBACK
#define WINHTTP_OPTION_CALLBACK                       1
#define WINHTTP_OPTION_RESOLVE_TIMEOUT                2
#define WINHTTP_OPTION_CONNECT_TIMEOUT                3
#define WINHTTP_OPTION_CONNECT_RETRIES                4
#define WINHTTP_OPTION_SEND_TIMEOUT                   5
#define WINHTTP_OPTION_RECEIVE_TIMEOUT                6
#define WINHTTP_OPTION_RECEIVE_RESPONSE_TIMEOUT       7
#define WINHTTP_OPTION_HANDLE_TYPE                    9
#define WINHTTP_OPTION_READ_BUFFER_SIZE              12
#define WINHTTP_OPTION_WRITE_BUFFER_SIZE             13
#define WINHTTP_OPT